/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.prestosql.operator.HashGenerator;
import io.prestosql.operator.scalar.CombineHashFunction;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import io.prestosql.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;

public class InterpretedHashGenerator
implements HashGenerator {
    private final List<Type> hashChannelTypes;
    private final int[] hashChannels;
    private final List<BlockTypeOperators.BlockPositionHashCode> hashCodeOperators;

    public InterpretedHashGenerator(List<Type> hashChannelTypes, List<Integer> hashChannels, BlockTypeOperators blockTypeOperators) {
        this(hashChannelTypes, Ints.toArray((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null")), blockTypeOperators);
    }

    public InterpretedHashGenerator(List<Type> hashChannelTypes, int[] hashChannels, BlockTypeOperators blockTypeOperators) {
        this.hashChannels = Objects.requireNonNull(hashChannels, "hashChannels is null");
        this.hashChannelTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannelTypes, "hashChannelTypes is null"));
        Preconditions.checkArgument((hashChannelTypes.size() == hashChannels.length ? 1 : 0) != 0);
        this.hashCodeOperators = (List)hashChannelTypes.stream().map(blockTypeOperators::getHashCodeOperator).collect(ImmutableList.toImmutableList());
    }

    @Override
    public long hashPosition(int position, Page page) {
        return this.hashPosition(position, arg_0 -> ((Page)page).getBlock(arg_0));
    }

    public long hashPosition(int position, IntFunction<Block> blockProvider) {
        long result = 0L;
        for (int i = 0; i < this.hashChannels.length; ++i) {
            Block block = blockProvider.apply(this.hashChannels[i]);
            result = CombineHashFunction.getHash(result, this.hashCodeOperators.get(i).hashCodeNullSafe(block, position));
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashChannelTypes", this.hashChannelTypes).add("hashChannels", (Object)this.hashChannels).toString();
    }
}

