/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.execution.Lifespan;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.HashGenerator;
import io.prestosql.operator.InterpretedHashGenerator;
import io.prestosql.operator.JoinBridgeManager;
import io.prestosql.operator.JoinOperatorFactory;
import io.prestosql.operator.JoinProbe;
import io.prestosql.operator.LookupJoinOperator;
import io.prestosql.operator.LookupJoinOperators;
import io.prestosql.operator.LookupOuterOperator;
import io.prestosql.operator.LookupSourceFactory;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.PrecomputedHashGenerator;
import io.prestosql.operator.ProcessorContext;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.operator.WorkProcessorOperatorAdapter;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.Type;
import io.prestosql.spiller.PartitioningSpillerFactory;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class LookupJoinOperatorFactory
implements JoinOperatorFactory,
WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final List<Type> probeTypes;
    private final List<Type> buildOutputTypes;
    private final LookupJoinOperators.JoinType joinType;
    private final JoinProbe.JoinProbeFactory joinProbeFactory;
    private final Optional<JoinOperatorFactory.OuterOperatorFactoryResult> outerOperatorFactoryResult;
    private final JoinBridgeManager<? extends LookupSourceFactory> joinBridgeManager;
    private final OptionalInt totalOperatorsCount;
    private final HashGenerator probeHashGenerator;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private boolean closed;

    public LookupJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactoryManager, List<Type> probeTypes, List<Type> probeOutputTypes, List<Type> buildOutputTypes, LookupJoinOperators.JoinType joinType, JoinProbe.JoinProbeFactory joinProbeFactory, BlockTypeOperators blockTypeOperators, OptionalInt totalOperatorsCount, List<Integer> probeJoinChannels, OptionalInt probeHashChannel, PartitioningSpillerFactory partitioningSpillerFactory) {
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
        this.buildOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null"));
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.joinBridgeManager = lookupSourceFactoryManager;
        this.joinBridgeManager.incrementProbeFactoryCount();
        this.outerOperatorFactoryResult = joinType == LookupJoinOperators.JoinType.INNER || joinType == LookupJoinOperators.JoinType.PROBE_OUTER ? Optional.empty() : Optional.of(new JoinOperatorFactory.OuterOperatorFactoryResult(new LookupOuterOperator.LookupOuterOperatorFactory(operatorId, planNodeId, probeOutputTypes, buildOutputTypes, lookupSourceFactoryManager), lookupSourceFactoryManager.getBuildExecutionStrategy()));
        this.totalOperatorsCount = Objects.requireNonNull(totalOperatorsCount, "totalOperatorsCount is null");
        Objects.requireNonNull(probeHashChannel, "probeHashChannel is null");
        if (probeHashChannel.isPresent()) {
            this.probeHashGenerator = new PrecomputedHashGenerator(probeHashChannel.getAsInt());
        } else {
            Objects.requireNonNull(probeJoinChannels, "probeJoinChannels is null");
            List hashTypes = (List)probeJoinChannels.stream().map(probeTypes::get).collect(ImmutableList.toImmutableList());
            this.probeHashGenerator = new InterpretedHashGenerator((List<Type>)hashTypes, probeJoinChannels, blockTypeOperators);
        }
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
    }

    private LookupJoinOperatorFactory(LookupJoinOperatorFactory other) {
        Objects.requireNonNull(other, "other is null");
        Preconditions.checkArgument((!other.closed ? 1 : 0) != 0, (Object)"cannot duplicated closed OperatorFactory");
        this.operatorId = other.operatorId;
        this.planNodeId = other.planNodeId;
        this.probeTypes = other.probeTypes;
        this.buildOutputTypes = other.buildOutputTypes;
        this.joinType = other.joinType;
        this.joinProbeFactory = other.joinProbeFactory;
        this.joinBridgeManager = other.joinBridgeManager;
        this.outerOperatorFactoryResult = other.outerOperatorFactoryResult;
        this.totalOperatorsCount = other.totalOperatorsCount;
        this.probeHashGenerator = other.probeHashGenerator;
        this.partitioningSpillerFactory = other.partitioningSpillerFactory;
        this.closed = false;
        this.joinBridgeManager.incrementProbeFactoryCount();
    }

    @Override
    public Optional<JoinOperatorFactory.OuterOperatorFactoryResult> createOuterOperatorFactory() {
        return this.outerOperatorFactoryResult;
    }

    @Override
    public Operator createOperator(DriverContext driverContext) {
        OperatorContext operatorContext = driverContext.addOperatorContext(this.getOperatorId(), this.getPlanNodeId(), this.getOperatorType());
        return new WorkProcessorOperatorAdapter(operatorContext, this);
    }

    @Override
    public void noMoreOperators() {
        this.close();
    }

    @Override
    public void noMoreOperators(Lifespan lifespan) {
        this.lifespanFinished(lifespan);
    }

    @Override
    public int getOperatorId() {
        return this.operatorId;
    }

    @Override
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @Override
    public String getOperatorType() {
        return LookupJoinOperator.class.getSimpleName();
    }

    @Override
    public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        LookupSourceFactory lookupSourceFactory = this.joinBridgeManager.getJoinBridge(processorContext.getLifespan());
        this.joinBridgeManager.probeOperatorCreated(processorContext.getLifespan());
        return new LookupJoinOperator(this.probeTypes, this.buildOutputTypes, this.joinType, lookupSourceFactory, this.joinProbeFactory, () -> this.joinBridgeManager.probeOperatorClosed(processorContext.getLifespan()), this.totalOperatorsCount, this.probeHashGenerator, this.partitioningSpillerFactory, processorContext, Optional.of(sourcePages));
    }

    @Override
    public WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator createAdapterOperator(ProcessorContext processorContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        LookupSourceFactory lookupSourceFactory = this.joinBridgeManager.getJoinBridge(processorContext.getLifespan());
        this.joinBridgeManager.probeOperatorCreated(processorContext.getLifespan());
        return new LookupJoinOperator(this.probeTypes, this.buildOutputTypes, this.joinType, lookupSourceFactory, this.joinProbeFactory, () -> this.joinBridgeManager.probeOperatorClosed(processorContext.getLifespan()), this.totalOperatorsCount, this.probeHashGenerator, this.partitioningSpillerFactory, processorContext, Optional.empty());
    }

    @Override
    public void lifespanFinished(Lifespan lifespan) {
        this.joinBridgeManager.probeOperatorFactoryClosed(lifespan);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closed = true;
        this.joinBridgeManager.probeOperatorFactoryClosedForAllLifespans();
    }

    @Override
    public LookupJoinOperatorFactory duplicate() {
        return new LookupJoinOperatorFactory(this);
    }
}

