/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PagesSpatialIndex;
import io.prestosql.operator.PagesSpatialIndexFactory;
import io.prestosql.operator.ReferenceCount;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class SpatialJoinOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final SpatialJoinNode.Type joinType;
    private final List<Type> probeTypes;
    private final List<Integer> probeOutputChannels;
    private final int probeGeometryChannel;
    private final Optional<Integer> partitionChannel;
    private final PagesSpatialIndexFactory pagesSpatialIndexFactory;
    private final Runnable onClose;
    private ListenableFuture<PagesSpatialIndex> pagesSpatialIndexFuture;
    private final PageBuilder pageBuilder;
    @Nullable
    private Page probe;
    private int probePosition;
    @Nullable
    private int[] joinPositions;
    private int nextJoinPositionIndex;
    private boolean matchFound;
    private boolean finishing;
    private boolean finished;
    private boolean closed;

    public SpatialJoinOperator(OperatorContext operatorContext, SpatialJoinNode.Type joinType, List<Type> probeTypes, List<Integer> probeOutputChannels, int probeGeometryChannel, Optional<Integer> partitionChannel, PagesSpatialIndexFactory pagesSpatialIndexFactory, Runnable onClose) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.probeTypes = ImmutableList.copyOf(probeTypes);
        this.probeOutputChannels = ImmutableList.copyOf(probeOutputChannels);
        this.probeGeometryChannel = probeGeometryChannel;
        this.partitionChannel = Objects.requireNonNull(partitionChannel, "partitionChannel is null");
        this.pagesSpatialIndexFactory = Objects.requireNonNull(pagesSpatialIndexFactory, "pagesSpatialIndexFactory is null");
        this.onClose = Objects.requireNonNull(onClose, "onClose is null");
        this.pagesSpatialIndexFuture = pagesSpatialIndexFactory.createPagesSpatialIndex();
        this.pageBuilder = new PageBuilder((List)ImmutableList.builder().addAll(probeOutputChannels.stream().map(probeTypes::get).iterator()).addAll(pagesSpatialIndexFactory.getOutputTypes()).build());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.pagesSpatialIndexFuture.isDone() && !this.pageBuilder.isFull() && this.probe == null;
    }

    @Override
    public void addInput(Page page) {
        Verify.verify((this.probe == null ? 1 : 0) != 0);
        this.probe = page;
        this.probePosition = 0;
        this.joinPositions = null;
    }

    @Override
    public Page getOutput() {
        Verify.verify((!this.finished ? 1 : 0) != 0);
        if (!this.pageBuilder.isFull() && this.probe != null) {
            this.processProbe();
        }
        if (this.pageBuilder.isFull()) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        if (this.finishing && this.probe == null) {
            Page page = null;
            if (!this.pageBuilder.isEmpty()) {
                page = this.pageBuilder.build();
                this.pageBuilder.reset();
            }
            this.finished = true;
            this.close();
            return page;
        }
        return null;
    }

    private void processProbe() {
        Verify.verifyNotNull((Object)this.probe);
        PagesSpatialIndex pagesSpatialIndex = (PagesSpatialIndex)MoreFutures.getDone(this.pagesSpatialIndexFuture);
        DriverYieldSignal yieldSignal = this.operatorContext.getDriverContext().getYieldSignal();
        while (this.probePosition < this.probe.getPositionCount()) {
            if (this.joinPositions == null) {
                this.joinPositions = pagesSpatialIndex.findJoinPositions(this.probePosition, this.probe, this.probeGeometryChannel, this.partitionChannel);
                this.localUserMemoryContext.setBytes(SizeOf.sizeOf((int[])this.joinPositions));
                this.nextJoinPositionIndex = 0;
                this.matchFound = false;
                if (yieldSignal.isSet()) {
                    return;
                }
            }
            while (this.nextJoinPositionIndex < this.joinPositions.length) {
                if (this.pageBuilder.isFull()) {
                    return;
                }
                int joinPosition = this.joinPositions[this.nextJoinPositionIndex];
                if (pagesSpatialIndex.isJoinPositionEligible(joinPosition, this.probePosition, this.probe)) {
                    this.pageBuilder.declarePosition();
                    this.appendProbe();
                    pagesSpatialIndex.appendTo(joinPosition, this.pageBuilder, this.probeOutputChannels.size());
                    this.matchFound = true;
                }
                ++this.nextJoinPositionIndex;
                if (!yieldSignal.isSet()) continue;
                return;
            }
            if (!this.matchFound && this.joinType == SpatialJoinNode.Type.LEFT) {
                if (this.pageBuilder.isFull()) {
                    return;
                }
                this.pageBuilder.declarePosition();
                this.appendProbe();
                int buildColumnCount = this.pagesSpatialIndexFactory.getOutputTypes().size();
                for (int i = 0; i < buildColumnCount; ++i) {
                    this.pageBuilder.getBlockBuilder(this.probeOutputChannels.size() + i).appendNull();
                }
            }
            this.joinPositions = null;
            this.localUserMemoryContext.setBytes(0L);
            ++this.probePosition;
        }
        this.probe = null;
        this.probePosition = 0;
    }

    private void appendProbe() {
        int outputChannelOffset = 0;
        for (int outputIndex : this.probeOutputChannels) {
            Type type = this.probeTypes.get(outputIndex);
            Block block = this.probe.getBlock(outputIndex);
            type.appendTo(block, this.probePosition, this.pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.pagesSpatialIndexFuture = null;
        this.onClose.run();
    }

    public static final class SpatialJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final SpatialJoinNode.Type joinType;
        private final List<Type> probeTypes;
        private final List<Integer> probeOutputChannels;
        private final int probeGeometryChannel;
        private final Optional<Integer> partitionChannel;
        private final PagesSpatialIndexFactory pagesSpatialIndexFactory;
        private final ReferenceCount referenceCount;
        private boolean closed;

        public SpatialJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, SpatialJoinNode.Type joinType, List<Type> probeTypes, List<Integer> probeOutputChannels, int probeGeometryChannel, Optional<Integer> partitionChannel, PagesSpatialIndexFactory pagesSpatialIndexFactory) {
            Preconditions.checkArgument((joinType == SpatialJoinNode.Type.INNER || joinType == SpatialJoinNode.Type.LEFT ? 1 : 0) != 0, (String)"unsupported join type: %s", (Object)((Object)joinType));
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.joinType = joinType;
            this.probeTypes = ImmutableList.copyOf(probeTypes);
            this.probeOutputChannels = ImmutableList.copyOf(probeOutputChannels);
            this.probeGeometryChannel = probeGeometryChannel;
            this.partitionChannel = Objects.requireNonNull(partitionChannel, "partitionChannel is null");
            this.pagesSpatialIndexFactory = Objects.requireNonNull(pagesSpatialIndexFactory, "pagesSpatialIndexFactory is null");
            this.referenceCount = new ReferenceCount(1);
            this.referenceCount.getFreeFuture().addListener(pagesSpatialIndexFactory::destroy, MoreExecutors.directExecutor());
        }

        private SpatialJoinOperatorFactory(SpatialJoinOperatorFactory other) {
            this.operatorId = other.operatorId;
            this.planNodeId = other.planNodeId;
            this.joinType = other.joinType;
            this.probeTypes = other.probeTypes;
            this.probeOutputChannels = other.probeOutputChannels;
            this.probeGeometryChannel = other.probeGeometryChannel;
            this.partitionChannel = other.partitionChannel;
            this.pagesSpatialIndexFactory = other.pagesSpatialIndexFactory;
            this.referenceCount = other.referenceCount;
            this.closed = false;
            this.referenceCount.retain();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, SpatialJoinOperator.class.getSimpleName());
            this.referenceCount.retain();
            return new SpatialJoinOperator(operatorContext, this.joinType, this.probeTypes, this.probeOutputChannels, this.probeGeometryChannel, this.partitionChannel, this.pagesSpatialIndexFactory, this.referenceCount::release);
        }

        @Override
        public void noMoreOperators() {
            if (this.closed) {
                return;
            }
            this.referenceCount.release();
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new SpatialJoinOperatorFactory(this);
        }
    }
}

