/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.base.Preconditions;
import io.airlift.stats.QuantileDigest;
import io.airlift.stats.TDigest;
import io.prestosql.operator.aggregation.ApproximateLongPercentileAggregations;
import io.prestosql.operator.aggregation.FloatingPointBitsConverterUtil;
import io.prestosql.operator.aggregation.state.QuantileDigestAndPercentileState;
import io.prestosql.operator.aggregation.state.TDigestAndPercentileState;
import io.prestosql.operator.scalar.TDigestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.util.Failures;

@AggregationFunction(value="approx_percentile")
public final class ApproximateDoublePercentileAggregations {
    private ApproximateDoublePercentileAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState TDigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="double") double percentile) {
        TDigest digest = state.getDigest();
        if (digest == null) {
            digest = new TDigest();
            state.setDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        state.setPercentile(percentile);
    }

    @InputFunction
    public static void weightedInput(@AggregationState TDigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="double") double weight, @SqlType(value="double") double percentile) {
        TDigestFunctions.verifyWeight(weight);
        TDigest digest = state.getDigest();
        if (digest == null) {
            digest = new TDigest();
            state.setDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value, weight);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        state.setPercentile(percentile);
    }

    @CombineFunction
    public static void combine(@AggregationState TDigestAndPercentileState state, TDigestAndPercentileState otherState) {
        TDigest input = otherState.getDigest();
        TDigest previous = state.getDigest();
        if (previous == null) {
            state.setDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.mergeWith(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
        state.setPercentile(otherState.getPercentile());
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState TDigestAndPercentileState state, BlockBuilder out) {
        TDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            DoubleType.DOUBLE.writeDouble(out, digest.valueAt(percentile));
        }
    }

    @Deprecated
    @Description(value="(DEPRECATED) Use approx_percentile(x, weight, percentile) instead")
    @InputFunction
    public static void weightedInput(@AggregationState QuantileDigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="double") double weight, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileAggregations.weightedInput(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, percentile, accuracy);
    }

    @CombineFunction
    public static void combine(@AggregationState QuantileDigestAndPercentileState state, QuantileDigestAndPercentileState otherState) {
        ApproximateLongPercentileAggregations.combine(state, otherState);
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState QuantileDigestAndPercentileState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            DoubleType.DOUBLE.writeDouble(out, FloatingPointBitsConverterUtil.sortableLongToDouble(digest.getQuantile(percentile)));
        }
    }
}

