/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.minmaxby.LongDoubleState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.RemoveInputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DoubleType;

@AggregationFunction(value="sum")
public final class DoubleSumAggregation {
    private DoubleSumAggregation() {
    }

    @InputFunction
    public static void sum(@AggregationState LongDoubleState state, @SqlType(value="double") double value) {
        state.setFirst(state.getFirst() + 1L);
        state.setSecond(state.getSecond() + value);
    }

    @RemoveInputFunction
    public static void removeInput(@AggregationState LongDoubleState state, @SqlType(value="double") double value) {
        state.setFirst(state.getFirst() - 1L);
        state.setSecond(state.getSecond() - value);
    }

    @CombineFunction
    public static void combine(@AggregationState LongDoubleState state, @AggregationState LongDoubleState otherState) {
        state.setFirst(state.getFirst() + otherState.getFirst());
        state.setSecond(state.getSecond() + otherState.getSecond());
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState LongDoubleState state, BlockBuilder out) {
        if (state.getFirst() == 0L) {
            out.appendNull();
        } else {
            DoubleType.DOUBLE.writeDouble(out, state.getSecond());
        }
    }
}

