/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.builder;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.aggregation.AccumulatorFactory;
import io.prestosql.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.type.BlockTypeOperators;
import java.io.Closeable;
import java.util.List;
import java.util.Optional;

public class MergingHashAggregationBuilder
implements Closeable {
    private final List<AccumulatorFactory> accumulatorFactories;
    private final AggregationNode.Step step;
    private final int expectedGroups;
    private final ImmutableList<Integer> groupByPartialChannels;
    private final Optional<Integer> hashChannel;
    private final OperatorContext operatorContext;
    private final WorkProcessor<Page> sortedPages;
    private InMemoryHashAggregationBuilder hashAggregationBuilder;
    private final List<Type> groupByTypes;
    private final LocalMemoryContext memoryContext;
    private final long memoryLimitForMerge;
    private final int overwriteIntermediateChannelOffset;
    private final JoinCompiler joinCompiler;
    private final BlockTypeOperators blockTypeOperators;

    public MergingHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, Optional<Integer> hashChannel, OperatorContext operatorContext, WorkProcessor<Page> sortedPages, AggregatedMemoryContext aggregatedMemoryContext, long memoryLimitForMerge, int overwriteIntermediateChannelOffset, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators) {
        ImmutableList.Builder groupByPartialChannels = ImmutableList.builder();
        for (int i = 0; i < groupByTypes.size(); ++i) {
            groupByPartialChannels.add((Object)i);
        }
        this.accumulatorFactories = accumulatorFactories;
        this.step = AggregationNode.Step.partialInput(step);
        this.expectedGroups = expectedGroups;
        this.groupByPartialChannels = groupByPartialChannels.build();
        this.hashChannel = hashChannel.isPresent() ? Optional.of(groupByTypes.size()) : hashChannel;
        this.operatorContext = operatorContext;
        this.sortedPages = sortedPages;
        this.groupByTypes = groupByTypes;
        this.memoryContext = aggregatedMemoryContext.newLocalMemoryContext(MergingHashAggregationBuilder.class.getSimpleName());
        this.memoryLimitForMerge = memoryLimitForMerge;
        this.overwriteIntermediateChannelOffset = overwriteIntermediateChannelOffset;
        this.joinCompiler = joinCompiler;
        this.blockTypeOperators = blockTypeOperators;
        this.rebuildHashAggregationBuilder();
    }

    public WorkProcessor<Page> buildResult() {
        return this.sortedPages.flatTransform(new WorkProcessor.Transformation<Page, WorkProcessor<Page>>(){
            boolean reset = true;
            long memorySize;

            @Override
            public WorkProcessor.TransformationState<WorkProcessor<Page>> process(Page inputPage) {
                boolean inputFinished;
                if (this.reset) {
                    MergingHashAggregationBuilder.this.rebuildHashAggregationBuilder();
                    this.memorySize = 0L;
                    this.reset = false;
                }
                boolean bl = inputFinished = inputPage == null;
                if (inputFinished && this.memorySize == 0L) {
                    return WorkProcessor.TransformationState.finished();
                }
                if (!inputFinished) {
                    boolean done = MergingHashAggregationBuilder.this.hashAggregationBuilder.processPage(inputPage).process();
                    Verify.verify((boolean)done);
                    this.memorySize = MergingHashAggregationBuilder.this.hashAggregationBuilder.getSizeInMemory();
                    MergingHashAggregationBuilder.this.memoryContext.setBytes(this.memorySize);
                    if (!MergingHashAggregationBuilder.this.shouldProduceOutput(this.memorySize)) {
                        return WorkProcessor.TransformationState.needsMoreData();
                    }
                }
                this.reset = true;
                return WorkProcessor.TransformationState.ofResult(MergingHashAggregationBuilder.this.hashAggregationBuilder.buildResult(), !inputFinished);
            }
        });
    }

    @Override
    public void close() {
        this.hashAggregationBuilder.close();
    }

    private boolean shouldProduceOutput(long memorySize) {
        return this.memoryLimitForMerge > 0L && memorySize > this.memoryLimitForMerge;
    }

    private void rebuildHashAggregationBuilder() {
        this.hashAggregationBuilder = new InMemoryHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, (List<Integer>)this.groupByPartialChannels, this.hashChannel, this.operatorContext, Optional.of(DataSize.succinctBytes((long)0L)), Optional.of(this.overwriteIntermediateChannelOffset), this.joinCompiler, this.blockTypeOperators, () -> true);
    }
}

