/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.histogram;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.aggregation.AccumulatorCompiler;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.histogram.HistogramState;
import io.prestosql.operator.aggregation.histogram.HistogramStateFactory;
import io.prestosql.operator.aggregation.histogram.HistogramStateSerializer;
import io.prestosql.operator.aggregation.histogram.TypedHistogram;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.type.BlockTypeOperators;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Histogram
extends SqlAggregationFunction {
    public static final String NAME = "histogram";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(Histogram.class, "output", Type.class, HistogramState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(Histogram.class, "input", Type.class, HistogramState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(Histogram.class, "combine", HistogramState.class, HistogramState.class);
    public static final int EXPECTED_SIZE_FOR_HASHING = 10;
    private final BlockTypeOperators blockTypeOperators;

    public Histogram(BlockTypeOperators blockTypeOperators) {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("K")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)BigintType.BIGINT.getTypeSignature()), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0])), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, "Count the number of times each value occurs", FunctionKind.AGGREGATE), true, false);
        this.blockTypeOperators = blockTypeOperators;
    }

    @Override
    public List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        Type outputType = functionBinding.getBoundSignature().getReturnType();
        return ImmutableList.of((Object)outputType.getTypeSignature());
    }

    @Override
    public InternalAggregationFunction specialize(FunctionBinding functionBinding) {
        Type keyType = functionBinding.getTypeVariable("K");
        BlockTypeOperators.BlockPositionEqual keyEqual = this.blockTypeOperators.getEqualOperator(keyType);
        BlockTypeOperators.BlockPositionHashCode keyHashCode = this.blockTypeOperators.getHashCodeOperator(keyType);
        Type outputType = functionBinding.getBoundSignature().getReturnType();
        return Histogram.generateAggregation(NAME, keyType, keyEqual, keyHashCode, outputType);
    }

    private static InternalAggregationFunction generateAggregation(String functionName, Type keyType, BlockTypeOperators.BlockPositionEqual keyEqual, BlockTypeOperators.BlockPositionHashCode keyHashCode, Type outputType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(Histogram.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)keyType);
        HistogramStateSerializer stateSerializer = new HistogramStateSerializer(outputType);
        Type intermediateType = stateSerializer.getSerializedType();
        MethodHandle inputFunction = INPUT_FUNCTION.bindTo(keyType);
        MethodHandle outputFunction = OUTPUT_FUNCTION.bindTo(outputType);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(functionName, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), Histogram.createInputParameterMetadata(keyType), inputFunction, Optional.empty(), COMBINE_FUNCTION, outputFunction, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(HistogramState.class, stateSerializer, new HistogramStateFactory(keyType, keyEqual, keyHashCode, 10))), outputType);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(functionName, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), outputType, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type keyType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, keyType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(Type type, HistogramState state, Block key, int position) {
        TypedHistogram typedHistogram = state.get();
        long startSize = typedHistogram.getEstimatedSize();
        typedHistogram.add(position, key, 1L);
        state.addMemoryUsage(typedHistogram.getEstimatedSize() - startSize);
    }

    public static void combine(HistogramState state, HistogramState otherState) {
        Objects.requireNonNull(otherState.get(), "scratch state should always be non-null");
        TypedHistogram typedHistogram = state.get();
        long startSize = typedHistogram.getEstimatedSize();
        typedHistogram.addAll(otherState.get());
        state.addMemoryUsage(typedHistogram.getEstimatedSize() - startSize);
    }

    public static void output(Type type, HistogramState state, BlockBuilder out) {
        TypedHistogram typedHistogram = state.get();
        typedHistogram.serialize(out);
    }
}

