/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.project;

import com.google.common.base.MoreObjects;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.Work;
import io.prestosql.operator.project.InputChannels;
import io.prestosql.operator.project.PageProjection;
import io.prestosql.operator.project.SelectedPositions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.relational.RowExpression;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

public class GeneratedPageProjection
implements PageProjection {
    private final RowExpression projection;
    private final boolean isDeterministic;
    private final InputChannels inputChannels;
    private final MethodHandle pageProjectionWorkFactory;
    private BlockBuilder blockBuilder;

    public GeneratedPageProjection(RowExpression projection, boolean isDeterministic, InputChannels inputChannels, MethodHandle pageProjectionWorkFactory) {
        this.projection = Objects.requireNonNull(projection, "projection is null");
        this.isDeterministic = isDeterministic;
        this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
        this.pageProjectionWorkFactory = Objects.requireNonNull(pageProjectionWorkFactory, "pageProjectionWorkFactory is null");
        this.blockBuilder = projection.getType().createBlockBuilder(null, 1);
    }

    @Override
    public Type getType() {
        return this.projection.getType();
    }

    @Override
    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        this.blockBuilder = this.blockBuilder.newBlockBuilderLike(null);
        try {
            return this.pageProjectionWorkFactory.invoke(this.blockBuilder, session, page, selectedPositions);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projection", (Object)this.projection).toString();
    }
}

