/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.JsonOperators;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.type.JsonType;
import io.prestosql.util.Failures;
import io.prestosql.util.JsonUtil;
import io.prestosql.util.Reflection;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RowToJsonCast
extends SqlOperator {
    public static final RowToJsonCast ROW_TO_JSON = new RowToJsonCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowToJsonCast.class, "toJson", List.class, Block.class);

    private RowToJsonCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)new TypeVariableConstraint("T", false, false, "row", (Set<TypeSignature>)ImmutableSet.of((Object)JsonType.JSON.getTypeSignature()), (Set<TypeSignature>)ImmutableSet.of())), (List<LongVariableConstraint>)ImmutableList.of(), JsonType.JSON.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false);
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Preconditions.checkArgument((functionBinding.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = functionBinding.getTypeVariable("T");
        Failures.checkCondition(JsonUtil.canCastToJson(type), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast %s to JSON", type);
        List fieldTypes = type.getTypeParameters();
        ArrayList<JsonUtil.JsonGeneratorWriter> fieldWriters = new ArrayList<JsonUtil.JsonGeneratorWriter>(fieldTypes.size());
        for (int i = 0; i < fieldTypes.size(); ++i) {
            fieldWriters.add(JsonUtil.JsonGeneratorWriter.createJsonGeneratorWriter((Type)fieldTypes.get(i)));
        }
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(fieldWriters);
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Slice toJson(List<JsonUtil.JsonGeneratorWriter> fieldWriters, Block block) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(40);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeStartArray();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    fieldWriters.get(i).writeJsonValue(jsonGenerator, block, i);
                }
                jsonGenerator.writeEndArray();
            }
            return output.slice();
        }
        catch (IOException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

