/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.airlift.stats.TDigest;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.util.Failures;
import java.util.List;
import java.util.stream.IntStream;

public final class TDigestFunctions {
    public static final double DEFAULT_WEIGHT = 1.0;

    private TDigestFunctions() {
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="double")
    public static double valueAtQuantile(@SqlType(value="tdigest") TDigest input, @SqlType(value="double") double quantile) {
        return input.valueAt(quantile);
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="array(double)")
    public static Block valuesAtQuantiles(@SqlType(value="tdigest") TDigest input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        List percentiles = (List)IntStream.range(0, percentilesArrayBlock.getPositionCount()).mapToDouble(i -> DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)).boxed().collect(ImmutableList.toImmutableList());
        Failures.checkCondition(Ordering.natural().isOrdered((Iterable)percentiles), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "percentiles must be sorted in increasing order", new Object[0]);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        List valuesAtPercentiles = input.valuesAt(percentiles);
        for (Double value : valuesAtPercentiles) {
            DoubleType.DOUBLE.writeDouble(output, value.doubleValue());
        }
        return output.build();
    }

    public static double verifyWeight(double weight) {
        Failures.checkCondition(weight >= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "weight must be >= 1, was %s", weight);
        return weight;
    }
}

