/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.oauth2;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class OAuth2Config {
    private Optional<String> stateKey = Optional.empty();
    private String authUrl;
    private String tokenUrl;
    private String jwksUrl;
    private String clientId;
    private String clientSecret;
    private Duration challengeTimeout = new Duration(15.0, TimeUnit.MINUTES);
    private Optional<String> userMappingPattern = Optional.empty();
    private Optional<File> userMappingFile = Optional.empty();

    public Optional<String> getStateKey() {
        return this.stateKey;
    }

    @Config(value="http-server.authentication.oauth2.state-key")
    @ConfigDescription(value="A secret key used by HMAC algorithm to sign the state parameter")
    public OAuth2Config setStateKey(String stateKey) {
        this.stateKey = Optional.ofNullable(stateKey);
        return this;
    }

    @NotNull
    public String getAuthUrl() {
        return this.authUrl;
    }

    @Config(value="http-server.authentication.oauth2.auth-url")
    @ConfigDescription(value="URL of the authorization server's authorization endpoint")
    public OAuth2Config setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
        return this;
    }

    @NotNull
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Config(value="http-server.authentication.oauth2.token-url")
    @ConfigDescription(value="URL of the authorization server's token endpoint")
    public OAuth2Config setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    @NotNull
    public String getJwksUrl() {
        return this.jwksUrl;
    }

    @Config(value="http-server.authentication.oauth2.jwks-url")
    @ConfigDescription(value="URL of the authorization server's JWKS (JSON Web Key Set) endpoint")
    public OAuth2Config setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
        return this;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @Config(value="http-server.authentication.oauth2.client-id")
    @ConfigDescription(value="Client ID")
    public OAuth2Config setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @NotNull
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Config(value="http-server.authentication.oauth2.client-secret")
    @ConfigDescription(value="Client secret")
    public OAuth2Config setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getChallengeTimeout() {
        return this.challengeTimeout;
    }

    @Config(value="http-server.authentication.oauth2.challenge-timeout")
    @ConfigDescription(value="Maximum duration of OAuth2 login challenge")
    public OAuth2Config setChallengeTimeout(Duration challengeTimeout) {
        this.challengeTimeout = challengeTimeout;
        return this;
    }

    public Optional<String> getUserMappingPattern() {
        return this.userMappingPattern;
    }

    @Config(value="http-server.authentication.oauth2.user-mapping.pattern")
    @ConfigDescription(value="Regex to match against user name")
    public OAuth2Config setUserMappingPattern(String userMappingPattern) {
        this.userMappingPattern = Optional.ofNullable(userMappingPattern);
        return this;
    }

    public Optional<@FileExists File> getUserMappingFile() {
        return this.userMappingFile;
    }

    @Config(value="http-server.authentication.oauth2.user-mapping.file")
    @ConfigDescription(value="File containing rules for mapping user")
    public OAuth2Config setUserMappingFile(File userMappingFile) {
        this.userMappingFile = Optional.ofNullable(userMappingFile);
        return this;
    }
}

