/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.oauth2;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.AccessTokenRequestParams;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.common.collect.ImmutableMap;
import io.prestosql.server.security.oauth2.ChallengeFailedException;
import io.prestosql.server.security.oauth2.OAuth2Client;
import io.prestosql.server.security.oauth2.OAuth2Config;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ScribeJavaOAuth2Client
implements OAuth2Client {
    private final DynamicCallbackOAuth2Service service;

    @Inject
    public ScribeJavaOAuth2Client(OAuth2Config config) {
        this.service = new DynamicCallbackOAuth2Service(config);
    }

    @Override
    public URI getAuthorizationUri(String state, URI callbackUri) {
        return URI.create(this.service.getAuthorizationUrl((Map)ImmutableMap.builder().put((Object)"redirect_uri", (Object)callbackUri.toString()).put((Object)"state", (Object)state).build()));
    }

    @Override
    public OAuth2Client.AccessToken getAccessToken(String code, URI callbackUri) throws ChallengeFailedException {
        OAuth2AccessToken accessToken = this.service.getAccessToken(code, callbackUri.toString());
        Optional<Instant> validUntil = Optional.ofNullable(accessToken.getExpiresIn()).map(expiresSeconds -> Instant.now().plusSeconds(expiresSeconds.intValue()));
        return new OAuth2Client.AccessToken(accessToken.getAccessToken(), validUntil);
    }

    private static class DynamicCallbackOAuth2Service
    extends OAuth20Service {
        public DynamicCallbackOAuth2Service(OAuth2Config config) {
            super((DefaultApi20)new OAuth2Api(config.getTokenUrl(), config.getAuthUrl()), config.getClientId(), config.getClientSecret(), null, "openid", "code", null, null, null, null);
        }

        public OAuth2AccessToken getAccessToken(String code, String callbackUrl) throws ChallengeFailedException {
            try {
                OAuthRequest request = this.createAccessTokenRequest(AccessTokenRequestParams.create((String)code));
                request.addParameter("redirect_uri", callbackUrl);
                return this.sendAccessTokenRequestSync(request);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ChallengeFailedException("Interrupted while fetching access token", e);
            }
            catch (Exception e) {
                throw new ChallengeFailedException("Error while fetching access token", e);
            }
        }

        private static class OAuth2Api
        extends DefaultApi20 {
            private final String accessTokenEndpoint;
            private final String authorizationBaseUrl;

            public OAuth2Api(String accessTokenEndpoint, String authorizationBaseUrl) {
                this.accessTokenEndpoint = Objects.requireNonNull(accessTokenEndpoint, "accessTokenEndpoint is null");
                this.authorizationBaseUrl = Objects.requireNonNull(authorizationBaseUrl, "authorizationBaseUrl is null");
            }

            public String getAccessTokenEndpoint() {
                return this.accessTokenEndpoint;
            }

            protected String getAuthorizationBaseUrl() {
                return this.authorizationBaseUrl;
            }
        }
    }
}

