/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;

public final class OAuthWebUiCookie {
    private static final String OAUTH2_COOKIE = "Presto-OAuth2-Token";

    private OAuthWebUiCookie() {
    }

    public static NewCookie create(String accessToken, Instant tokenExpiration, boolean secure) {
        return new NewCookie(OAUTH2_COOKIE, accessToken, "/ui/", null, 1, null, -1, Date.from(tokenExpiration), secure, true);
    }

    public static Optional<String> read(ContainerRequestContext request) {
        return Optional.ofNullable((Cookie)request.getCookies().get(OAUTH2_COOKIE)).map(Cookie::getValue).filter(Predicate.not(String::isBlank));
    }

    public static NewCookie delete(boolean secure) {
        return new NewCookie(OAUTH2_COOKIE, "delete", "/ui/", null, 1, null, 0, null, secure, true);
    }
}

