/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.type.FunctionType;
import java.util.List;
import java.util.Map;

public final class DesugarTryExpressionRewriter {
    private DesugarTryExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression, Metadata metadata, TypeAnalyzer typeAnalyzer, Session session, SymbolAllocator symbolAllocator) {
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata, expressionTypes), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Metadata metadata, Map<NodeRef<Expression>, Type> expressionTypes) {
            this.metadata = metadata;
            this.expressionTypes = expressionTypes;
        }

        public Expression rewriteTryExpression(TryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Type type = this.expressionTypes.get(NodeRef.of((Node)node));
            Expression expression = treeRewriter.rewrite(node.getInnerExpression(), (Object)context);
            return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$internal$try")).addArgument(new FunctionType((List<Type>)ImmutableList.of(), type), (Expression)new LambdaExpression((List)ImmutableList.of(), expression)).build();
        }
    }
}

