/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.SliceUtf8;
import io.prestosql.block.BlockSerdeUtil;
import io.prestosql.metadata.LiteralFunction;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.operator.scalar.VarbinaryFunctions;
import io.prestosql.operator.scalar.timestamp.TimestampToVarcharCast;
import io.prestosql.operator.scalar.timestamptz.TimestampWithTimeZoneToVarcharCast;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.predicate.Utils;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.SqlDate;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.TimestampLiteral;
import io.prestosql.type.DateTimes;
import io.prestosql.type.UnknownType;
import java.util.List;
import java.util.Objects;

public final class LiteralEncoder {
    private final Metadata metadata;

    public LiteralEncoder(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public List<Expression> toExpressions(List<?> objects, List<? extends Type> types) {
        Objects.requireNonNull(objects, "objects is null");
        Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument((objects.size() == types.size() ? 1 : 0) != 0, (Object)"objects and types do not have the same size");
        ImmutableList.Builder expressions = ImmutableList.builder();
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            Type type = types.get(i);
            expressions.add((Object)this.toExpression(object, type));
        }
        return expressions.build();
    }

    public Expression toExpression(Object object, Type type) {
        Expression argument;
        Objects.requireNonNull(type, "type is null");
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (object == null) {
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                return new NullLiteral();
            }
            return new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType(type), false, true);
        }
        Preconditions.checkArgument((boolean)Primitives.wrap((Class)type.getJavaType()).isInstance(object), (String)"object.getClass (%s) and type.getJavaType (%s) do not agree", object.getClass(), (Object)type.getJavaType());
        if (type.equals(TinyintType.TINYINT)) {
            return new GenericLiteral("TINYINT", object.toString());
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return new GenericLiteral("SMALLINT", object.toString());
        }
        if (type.equals(IntegerType.INTEGER)) {
            return new LongLiteral(object.toString());
        }
        if (type.equals(BigintType.BIGINT)) {
            LongLiteral expression = new LongLiteral(object.toString());
            if (expression.getValue() >= Integer.MIN_VALUE && expression.getValue() <= Integer.MAX_VALUE) {
                return new GenericLiteral("BIGINT", object.toString());
            }
            return new LongLiteral(object.toString());
        }
        if (type.equals(DoubleType.DOUBLE)) {
            Double value = (Double)object;
            if (value.isNaN()) {
                return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"nan")).build();
            }
            if (value.equals(Double.NEGATIVE_INFINITY)) {
                return ArithmeticUnaryExpression.negative((Expression)new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"infinity")).build());
            }
            if (value.equals(Double.POSITIVE_INFINITY)) {
                return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"infinity")).build();
            }
            return new DoubleLiteral(object.toString());
        }
        if (type.equals(RealType.REAL)) {
            Float value = Float.valueOf(Float.intBitsToFloat(((Long)object).intValue()));
            if (value.isNaN()) {
                return new Cast((Expression)new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"nan")).build(), TypeSignatureTranslator.toSqlType((Type)RealType.REAL));
            }
            if (value.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                return ArithmeticUnaryExpression.negative((Expression)new Cast((Expression)new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"infinity")).build(), TypeSignatureTranslator.toSqlType((Type)RealType.REAL)));
            }
            if (value.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                return new Cast((Expression)new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"infinity")).build(), TypeSignatureTranslator.toSqlType((Type)RealType.REAL));
            }
            return new GenericLiteral("REAL", value.toString());
        }
        if (type instanceof DecimalType) {
            String string = Decimals.isShortDecimal((Type)type) ? Decimals.toString((long)((Long)object), (int)((DecimalType)type).getScale()) : Decimals.toString((Slice)((Slice)object), (int)((DecimalType)type).getScale());
            return new Cast((Expression)new DecimalLiteral(string), TypeSignatureTranslator.toSqlType(type));
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Slice value = (Slice)object;
            StringLiteral stringLiteral = new StringLiteral(value.toStringUtf8());
            if (!varcharType.isUnbounded() && varcharType.getBoundedLength() == SliceUtf8.countCodePoints((Slice)value)) {
                return stringLiteral;
            }
            return new Cast((Expression)stringLiteral, TypeSignatureTranslator.toSqlType(type), false, true);
        }
        if (type instanceof CharType) {
            StringLiteral stringLiteral = new StringLiteral(((Slice)object).toStringUtf8());
            return new Cast((Expression)stringLiteral, TypeSignatureTranslator.toSqlType(type), false, true);
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanLiteral(object.toString());
        }
        if (type.equals(DateType.DATE)) {
            return new GenericLiteral("DATE", new SqlDate(Math.toIntExact((Long)object)).toString());
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            String representation = timestampType.isShort() ? TimestampToVarcharCast.cast((long)timestampType.getPrecision(), (Long)object).toStringUtf8() : TimestampToVarcharCast.cast((long)timestampType.getPrecision(), (LongTimestamp)object).toStringUtf8();
            return new TimestampLiteral(representation);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            String representation = timestampWithTimeZoneType.isShort() ? TimestampWithTimeZoneToVarcharCast.cast((long)timestampWithTimeZoneType.getPrecision(), (Long)object).toStringUtf8() : TimestampWithTimeZoneToVarcharCast.cast((long)timestampWithTimeZoneType.getPrecision(), (LongTimestampWithTimeZone)object).toStringUtf8();
            if (object.equals(DateTimes.parseTimestampWithTimeZone(timestampWithTimeZoneType.getPrecision(), representation))) {
                return new TimestampLiteral(representation);
            }
        }
        if (!type.getJavaType().isPrimitive() && type.getJavaType() != Slice.class && type.getJavaType() != Block.class) {
            object = Utils.nativeValueToBlock((Type)type, (Object)object);
        }
        if (object instanceof Block) {
            DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(((Block)object).getSizeInBytes()));
            BlockSerdeUtil.writeBlock(this.metadata.getBlockEncodingSerde(), (SliceOutput)output, (Block)object);
            object = output.slice();
        }
        Type argumentType = LiteralFunction.typeForMagicLiteral(type);
        if (object instanceof Slice) {
            Slice encoded = VarbinaryFunctions.toBase64((Slice)object);
            argument = new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"from_base64")).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral(encoded.toStringUtf8())).build();
        } else {
            argument = this.toExpression(object, argumentType);
        }
        ResolvedFunction resolvedFunction = this.metadata.getCoercion(QualifiedName.of((String)"$literal$"), argumentType, type);
        return new FunctionCallBuilder(this.metadata).setName(resolvedFunction.toQualifiedName()).addArgument(argumentType, argument).build();
    }
}

