/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class LocalDynamicFilterConsumer {
    private final Map<DynamicFilterId, Integer> buildChannels;
    private final Map<DynamicFilterId, Type> filterBuildTypes;
    private final SettableFuture<TupleDomain<DynamicFilterId>> resultFuture;
    private final int partitionCount;
    private final List<TupleDomain<DynamicFilterId>> partitions;

    public LocalDynamicFilterConsumer(Map<DynamicFilterId, Integer> buildChannels, Map<DynamicFilterId, Type> filterBuildTypes, int partitionCount) {
        this.buildChannels = Objects.requireNonNull(buildChannels, "buildChannels is null");
        this.filterBuildTypes = Objects.requireNonNull(filterBuildTypes, "filterBuildTypes is null");
        Verify.verify((boolean)buildChannels.keySet().equals(filterBuildTypes.keySet()), (String)"filterBuildTypes and buildChannels must have same keys", (Object[])new Object[0]);
        this.resultFuture = SettableFuture.create();
        this.partitionCount = partitionCount;
        this.partitions = new ArrayList<TupleDomain<DynamicFilterId>>(partitionCount);
    }

    public ListenableFuture<Map<DynamicFilterId, Domain>> getDynamicFilterDomains() {
        return Futures.transform(this.resultFuture, this::convertTupleDomain, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPartition(TupleDomain<DynamicFilterId> tupleDomain) {
        TupleDomain result = null;
        LocalDynamicFilterConsumer localDynamicFilterConsumer = this;
        synchronized (localDynamicFilterConsumer) {
            Verify.verify((this.partitions.size() < this.partitionCount ? 1 : 0) != 0);
            this.partitions.add(tupleDomain);
            if (this.partitions.size() == this.partitionCount || tupleDomain.isAll()) {
                result = TupleDomain.columnWiseUnion(this.partitions);
            }
        }
        if (result != null) {
            this.resultFuture.set((Object)result);
        }
    }

    private Map<DynamicFilterId, Domain> convertTupleDomain(TupleDomain<DynamicFilterId> result) {
        if (result.isNone()) {
            return (Map)this.buildChannels.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), filterId -> Domain.none((Type)this.filterBuildTypes.get(filterId))));
        }
        HashMap domains = new HashMap((Map)result.getDomains().get());
        this.buildChannels.keySet().forEach(filterId -> domains.putIfAbsent(filterId, Domain.all((Type)this.filterBuildTypes.get(filterId))));
        return ImmutableMap.copyOf(domains);
    }

    public static LocalDynamicFilterConsumer create(JoinNode planNode, List<Type> buildSourceTypes, int partitionCount, Set<DynamicFilterId> collectedFilters) {
        Preconditions.checkArgument((!planNode.getDynamicFilters().isEmpty() ? 1 : 0) != 0, (Object)"Join node dynamicFilters is empty.");
        Preconditions.checkArgument((!collectedFilters.isEmpty() ? 1 : 0) != 0, (Object)"Collected dynamic filters set is empty");
        Preconditions.checkArgument((boolean)planNode.getDynamicFilters().keySet().containsAll(collectedFilters), (Object)"Collected dynamic filters set is not subset of join dynamic filters");
        PlanNode buildNode = planNode.getRight();
        Map buildChannels = (Map)planNode.getDynamicFilters().entrySet().stream().filter(entry -> collectedFilters.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            Symbol buildSymbol = (Symbol)entry.getValue();
            int buildChannelIndex = buildNode.getOutputSymbols().indexOf(buildSymbol);
            Verify.verify((buildChannelIndex >= 0 ? 1 : 0) != 0);
            return buildChannelIndex;
        }));
        Map filterBuildTypes = (Map)buildChannels.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Type)buildSourceTypes.get((Integer)entry.getValue())));
        return new LocalDynamicFilterConsumer(buildChannels, filterBuildTypes, partitionCount);
    }

    public Map<DynamicFilterId, Integer> getBuildChannels() {
        return this.buildChannels;
    }

    public Consumer<TupleDomain<DynamicFilterId>> getTupleDomainConsumer() {
        return this::addPartition;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("buildChannels", this.buildChannels).add("partitionCount", this.partitionCount).add("partitions", this.partitions).toString();
    }
}

