/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Scope;
import io.prestosql.sql.planner.PlanBuilder;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.QueryPlanner;
import io.prestosql.sql.planner.RelationPlan;
import io.prestosql.sql.planner.RelationPlanner;
import io.prestosql.sql.planner.ScopeAware;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TranslationMap;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.QuantifiedComparisonExpression;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.SubqueryExpression;
import io.prestosql.type.TypeCoercion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class SubqueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final Metadata metadata;
    private final TypeCoercion typeCoercion;
    private final Session session;
    private final Map<NodeRef<Node>, RelationPlan> recursiveSubqueries;

    SubqueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, Metadata metadata, TypeCoercion typeCoercion, Optional<TranslationMap> outerContext, Session session, Map<NodeRef<Node>, RelationPlan> recursiveSubqueries) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeCoercion, "typeCoercion is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(recursiveSubqueries, "recursiveSubqueries is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.metadata = metadata;
        this.typeCoercion = typeCoercion;
        this.session = session;
        this.recursiveSubqueries = recursiveSubqueries;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Collection<Expression> expressions, Node node) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, node);
        }
        return builder;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Node node) {
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, this.analysis.getInPredicateSubqueries(node)))) {
            builder = this.planInPredicate(builder, cluster, node);
        }
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, this.analysis.getScalarSubqueries(node)))) {
            builder = this.planScalarSubquery(builder, cluster);
        }
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, this.analysis.getExistsSubqueries(node)))) {
            builder = this.planExists(builder, cluster);
        }
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, this.analysis.getQuantifiedComparisonSubqueries(node)))) {
            builder = this.planQuantifiedComparison(builder, cluster, node);
        }
        return builder;
    }

    private <T extends Expression> List<T> selectSubqueries(PlanBuilder subPlan, Expression parent, List<T> candidates) {
        SuccessorsFunction recurse = expression -> {
            if (expression instanceof Expression && !this.analysis.isColumnReference((Expression)expression) && !subPlan.canTranslate((Expression)expression)) {
                return expression.getChildren();
            }
            return ImmutableList.of();
        };
        Iterable allSubExpressions = Traverser.forTree((SuccessorsFunction)recurse).depthFirstPreOrder((Object)parent);
        return (List)candidates.stream().filter(candidate -> Streams.stream((Iterable)allSubExpressions).anyMatch(child -> child == candidate)).filter(candidate -> !subPlan.canTranslate((Expression)candidate)).collect(ImmutableList.toImmutableList());
    }

    private <T extends Expression> Collection<Cluster<T>> cluster(Scope scope, List<T> expressions) {
        LinkedHashMap<ScopeAware, List> sets = new LinkedHashMap<ScopeAware, List>();
        for (Expression expression : expressions) {
            sets.computeIfAbsent(ScopeAware.scopeAwareKey(expression, this.analysis, scope), key -> new ArrayList()).add(expression);
        }
        return (Collection)sets.values().stream().map(cluster -> Cluster.newCluster(cluster, scope, this.analysis)).collect(ImmutableList.toImmutableList());
    }

    private PlanBuilder planInPredicate(PlanBuilder subPlan, Cluster<InPredicate> cluster, Node node) {
        InPredicate predicate = cluster.getRepresentative();
        Expression value = predicate.getValue();
        SubqueryExpression subquery = (SubqueryExpression)predicate.getValueList();
        Symbol output = this.symbolAllocator.newSymbol((Expression)predicate, (Type)BooleanType.BOOLEAN);
        subPlan = this.handleSubqueries(subPlan, value, node);
        subPlan = this.planInPredicate(subPlan, value, subquery, output, (Expression)predicate);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
    }

    private PlanBuilder planInPredicate(PlanBuilder subPlan, Expression value, SubqueryExpression subquery, Symbol output, Expression originalExpression) {
        RelationPlan relationPlan = this.planSubquery((Expression)subquery, subPlan.getTranslations());
        PlanBuilder subqueryPlan = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(subquery, this.analysis, relationPlan.getScope()), (Object)((Symbol)Iterables.getOnlyElement(relationPlan.getFieldMappings()))));
        QueryPlanner.PlanAndMappings subqueryCoercions = QueryPlanner.coerce(subqueryPlan, (List<Expression>)ImmutableList.of((Object)subquery), this.analysis, this.idAllocator, this.symbolAllocator, this.typeCoercion);
        subqueryPlan = subqueryCoercions.getSubPlan();
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)value), this.symbolAllocator, this.idAllocator);
        QueryPlanner.PlanAndMappings subplanCoercions = QueryPlanner.coerce(subPlan, (List<Expression>)ImmutableList.of((Object)value), this.analysis, this.idAllocator, this.symbolAllocator, this.typeCoercion);
        subPlan = subplanCoercions.getSubPlan();
        return new PlanBuilder(subPlan.getTranslations(), new ApplyNode(this.idAllocator.getNextId(), subPlan.getRoot(), subqueryPlan.getRoot(), Assignments.of(output, (Expression)new InPredicate((Expression)subplanCoercions.get(value).toSymbolReference(), (Expression)subqueryCoercions.get((Expression)subquery).toSymbolReference())), subPlan.getRoot().getOutputSymbols(), (Node)originalExpression));
    }

    private PlanBuilder planScalarSubquery(PlanBuilder subPlan, Cluster<SubqueryExpression> cluster) {
        SubqueryExpression scalarSubquery = cluster.getRepresentative();
        RelationPlan relationPlan = this.planSubquery((Expression)scalarSubquery, subPlan.getTranslations());
        PlanBuilder subqueryPlan = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        subqueryPlan = subqueryPlan.withNewRoot(new EnforceSingleRowNode(this.idAllocator.getNextId(), subqueryPlan.getRoot()));
        return this.appendCorrelatedJoin(subPlan, subqueryPlan, scalarSubquery.getQuery(), CorrelatedJoinNode.Type.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, this.mapAll(cluster, subPlan.getScope(), (Symbol)Iterables.getOnlyElement(relationPlan.getFieldMappings())));
    }

    public PlanBuilder appendCorrelatedJoin(PlanBuilder subPlan, PlanBuilder subqueryPlan, Query query, CorrelatedJoinNode.Type type, Expression filterCondition, Map<ScopeAware<Expression>, Symbol> mappings) {
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(mappings), new CorrelatedJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), subqueryPlan.getRoot(), subPlan.getRoot().getOutputSymbols(), type, filterCondition, (Node)query));
    }

    private PlanBuilder planExists(PlanBuilder subPlan, Cluster<ExistsPredicate> cluster) {
        ExistsPredicate existsPredicate = cluster.getRepresentative();
        Expression subquery = existsPredicate.getSubquery();
        Symbol exists = this.symbolAllocator.newSymbol("exists", (Type)BooleanType.BOOLEAN);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), exists)), new ApplyNode(this.idAllocator.getNextId(), subPlan.getRoot(), this.planSubquery(subquery, subPlan.getTranslations()).getRoot(), Assignments.of(exists, (Expression)new ExistsPredicate((Expression)BooleanLiteral.TRUE_LITERAL)), subPlan.getRoot().getOutputSymbols(), (Node)subquery));
    }

    private RelationPlan planSubquery(Expression subquery, TranslationMap outerContext) {
        return (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, Optional.of(outerContext), this.session, this.recursiveSubqueries).process((Node)subquery, null);
    }

    private PlanBuilder planQuantifiedComparison(PlanBuilder subPlan, Cluster<QuantifiedComparisonExpression> cluster, Node node) {
        QuantifiedComparisonExpression quantifiedComparison = cluster.getRepresentative();
        ComparisonExpression.Operator operator = quantifiedComparison.getOperator();
        QuantifiedComparisonExpression.Quantifier quantifier = quantifiedComparison.getQuantifier();
        Expression value = quantifiedComparison.getValue();
        SubqueryExpression subquery = (SubqueryExpression)quantifiedComparison.getSubquery();
        subPlan = this.handleSubqueries(subPlan, value, node);
        Symbol output = this.symbolAllocator.newSymbol((Expression)quantifiedComparison, (Type)BooleanType.BOOLEAN);
        switch (operator) {
            case EQUAL: {
                switch (quantifier) {
                    case ALL: {
                        subPlan = this.planQuantifiedComparison(subPlan, operator, quantifier, value, (Expression)subquery, output);
                        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(quantifiedComparison, this.analysis, subPlan.getScope()), (Object)output)), subPlan.getRoot());
                    }
                    case ANY: 
                    case SOME: {
                        subPlan = this.planInPredicate(subPlan, value, subquery, output, (Expression)quantifiedComparison);
                        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
                    }
                }
                break;
            }
            case NOT_EQUAL: {
                switch (quantifier) {
                    case ALL: {
                        subPlan = this.planInPredicate(subPlan, value, subquery, output, (Expression)quantifiedComparison);
                        return this.addNegation(subPlan, cluster, output);
                    }
                    case ANY: 
                    case SOME: {
                        subPlan = this.planQuantifiedComparison(subPlan, ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, value, (Expression)subquery, output);
                        return this.addNegation(subPlan, cluster, output);
                    }
                }
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                subPlan = this.planQuantifiedComparison(subPlan, operator, quantifier, value, (Expression)subquery, output);
                return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected quantified comparison: '%s %s'", operator.getValue(), quantifier));
    }

    private PlanBuilder addNegation(PlanBuilder subPlan, Cluster<? extends Expression> cluster, Symbol input) {
        Symbol output = this.symbolAllocator.newSymbol("not", (Type)BooleanType.BOOLEAN);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(output, (Expression)new NotExpression((Expression)input.toSymbolReference())).build()));
    }

    private PlanBuilder planQuantifiedComparison(PlanBuilder subPlan, ComparisonExpression.Operator operator, QuantifiedComparisonExpression.Quantifier quantifier, Expression value, Expression subquery, Symbol assignment) {
        RelationPlan relationPlan = this.planSubquery(subquery, subPlan.getTranslations());
        PlanBuilder subqueryPlan = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(subquery, this.analysis, relationPlan.getScope()), (Object)((Symbol)Iterables.getOnlyElement(relationPlan.getFieldMappings()))));
        QueryPlanner.PlanAndMappings subqueryCoercions = QueryPlanner.coerce(subqueryPlan, (List<Expression>)ImmutableList.of((Object)subquery), this.analysis, this.idAllocator, this.symbolAllocator, this.typeCoercion);
        subqueryPlan = subqueryCoercions.getSubPlan();
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)value), this.symbolAllocator, this.idAllocator);
        QueryPlanner.PlanAndMappings subplanCoercions = QueryPlanner.coerce(subPlan, (List<Expression>)ImmutableList.of((Object)value), this.analysis, this.idAllocator, this.symbolAllocator, this.typeCoercion);
        subPlan = subplanCoercions.getSubPlan();
        return new PlanBuilder(subPlan.getTranslations(), new ApplyNode(this.idAllocator.getNextId(), subPlan.getRoot(), subqueryPlan.getRoot(), Assignments.of(assignment, (Expression)new QuantifiedComparisonExpression(operator, quantifier, (Expression)subplanCoercions.get(value).toSymbolReference(), (Expression)subqueryCoercions.get(subquery).toSymbolReference())), subPlan.getRoot().getOutputSymbols(), (Node)subquery));
    }

    private <T extends Expression> Map<ScopeAware<Expression>, Symbol> mapAll(Cluster<T> cluster, Scope scope, Symbol output) {
        return (Map)cluster.getExpressions().stream().collect(ImmutableMap.toImmutableMap(expression -> ScopeAware.scopeAwareKey(expression, this.analysis, scope), expression -> output, (first, second) -> first));
    }

    private static class Cluster<T extends Expression> {
        private final List<T> expressions;

        private Cluster(List<T> expressions) {
            Preconditions.checkArgument((!expressions.isEmpty() ? 1 : 0) != 0, (Object)"Cluster is empty");
            this.expressions = ImmutableList.copyOf(expressions);
        }

        public static <T extends Expression> Cluster<T> newCluster(List<T> expressions, Scope scope, Analysis analysis) {
            long count = expressions.stream().map(expression -> ScopeAware.scopeAwareKey(expression, analysis, scope)).distinct().count();
            Preconditions.checkArgument((count == 1L ? 1 : 0) != 0, (Object)"Cluster contains expressions that are not equivalent to each other");
            return new Cluster<T>(expressions);
        }

        public List<T> getExpressions() {
            return this.expressions;
        }

        public T getRepresentative() {
            return (T)((Expression)this.expressions.get(0));
        }
    }
}

