/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.TableScanRedirectApplicationResult;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.DomainTranslator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ApplyTableScanRedirection
implements Rule<TableScanNode> {
    private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan();
    private final Metadata metadata;
    private final DomainTranslator domainTranslator;

    public ApplyTableScanRedirection(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.domainTranslator = new DomainTranslator(metadata);
    }

    @Override
    public Pattern<TableScanNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableScanNode scanNode, Captures captures, Rule.Context context) {
        Optional<TableScanRedirectApplicationResult> tableScanRedirectApplicationResult = this.metadata.applyTableScanRedirect(context.getSession(), scanNode.getTable());
        if (tableScanRedirectApplicationResult.isEmpty()) {
            return Rule.Result.empty();
        }
        CatalogSchemaTableName destinationTable = tableScanRedirectApplicationResult.get().getDestinationTable();
        Optional<TableHandle> destinationTableHandle = this.metadata.getTableHandle(context.getSession(), QualifiedObjectName.convertFromSchemaTableName(destinationTable.getCatalogName()).apply(destinationTable.getSchemaTableName()));
        if (destinationTableHandle.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, String.format("Destination table %s from table scan redirection not found", destinationTable));
        }
        if (destinationTableHandle.get().equals(scanNode.getTable())) {
            return Rule.Result.empty();
        }
        Map columnMapping = tableScanRedirectApplicationResult.get().getDestinationColumns();
        Map<String, ColumnHandle> destinationColumnHandles = this.metadata.getColumnHandles(context.getSession(), destinationTableHandle.get());
        Map newAssignments = (Map)scanNode.getAssignments().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            Type redirectedType;
            String destinationColumn = (String)columnMapping.get(entry.getValue());
            if (destinationColumn == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find mapping for source column %s in table scan redirection", entry.getValue()));
            }
            ColumnHandle destinationColumnHandle = (ColumnHandle)destinationColumnHandles.get(destinationColumn);
            if (destinationColumnHandle == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find handle for column %s in destination table %s", destinationColumn, destinationTable));
            }
            Type sourceType = context.getSymbolAllocator().getTypes().get((Symbol)entry.getKey());
            if (!sourceType.equals(redirectedType = this.metadata.getColumnMetadata(context.getSession(), (TableHandle)destinationTableHandle.get(), destinationColumnHandle).getType())) {
                ApplyTableScanRedirection.throwTypeMismatchException(destinationTable, destinationColumn, redirectedType, scanNode.getTable(), (ColumnHandle)entry.getValue(), sourceType);
            }
            return destinationColumnHandle;
        }));
        TupleDomain requiredFilter = tableScanRedirectApplicationResult.get().getFilter();
        if (requiredFilter.isAll()) {
            return Rule.Result.ofPlanNode(new TableScanNode(scanNode.getId(), destinationTableHandle.get(), scanNode.getOutputSymbols(), newAssignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), scanNode.isForDelete()));
        }
        ImmutableMap.Builder newAssignmentsBuilder = ImmutableMap.builder().putAll(newAssignments);
        ImmutableList.Builder newOutputSymbolsBuilder = ImmutableList.builder().addAll(scanNode.getOutputSymbols());
        ImmutableBiMap inverseAssignments = ImmutableBiMap.copyOf(scanNode.getAssignments()).inverse();
        ImmutableBiMap inverseColumnsMapping = ImmutableBiMap.copyOf((Map)columnMapping).inverse();
        TupleDomain transformedConstraint = requiredFilter.transform(arg_0 -> this.lambda$apply$1((Map)inverseColumnsMapping, (Map)inverseAssignments, requiredFilter, destinationColumnHandles, context, destinationTableHandle, destinationTable, scanNode, newAssignmentsBuilder, newOutputSymbolsBuilder, arg_0));
        ImmutableList newOutputSymbols = newOutputSymbolsBuilder.build();
        TableScanNode newScanNode = new TableScanNode(scanNode.getId(), destinationTableHandle.get(), (List<Symbol>)newOutputSymbols, (Map<Symbol, ColumnHandle>)newAssignmentsBuilder.build(), (TupleDomain<ColumnHandle>)TupleDomain.all(), scanNode.isForDelete());
        FilterNode filterNode = new FilterNode(context.getIdAllocator().getNextId(), newScanNode, this.domainTranslator.toPredicate((TupleDomain<Symbol>)transformedConstraint));
        if (newOutputSymbols.size() == scanNode.getOutputSymbols().size()) {
            return Rule.Result.ofPlanNode(filterNode);
        }
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), filterNode, Assignments.identity(scanNode.getOutputSymbols())));
    }

    private static void throwTypeMismatchException(CatalogSchemaTableName destinationTable, String destinationColumn, Type destinationType, TableHandle sourceTable, ColumnHandle sourceColumnHandle, Type sourceType) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Redirected column %s.%s has type %s, different from source column %s.%s type: %s", destinationTable, destinationColumn, destinationType, sourceTable, sourceColumnHandle, sourceType));
    }

    private /* synthetic */ Symbol lambda$apply$1(Map inverseColumnsMapping, Map inverseAssignments, TupleDomain requiredFilter, Map destinationColumnHandles, Rule.Context context, Optional destinationTableHandle, CatalogSchemaTableName destinationTable, TableScanNode scanNode, ImmutableMap.Builder newAssignmentsBuilder, ImmutableList.Builder newOutputSymbolsBuilder, String destinationColumn) {
        ColumnHandle sourceColumnHandle = (ColumnHandle)inverseColumnsMapping.get(destinationColumn);
        if (sourceColumnHandle == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find mapping for destination column %s in table scan redirection", destinationColumn));
        }
        Symbol symbol = (Symbol)inverseAssignments.get(sourceColumnHandle);
        if (symbol != null) {
            return symbol;
        }
        Type domainType = ((Domain)((Map)requiredFilter.getDomains().get()).get(destinationColumn)).getType();
        ColumnHandle destinationColumnHandle = (ColumnHandle)destinationColumnHandles.get(destinationColumn);
        Type redirectedType = this.metadata.getColumnMetadata(context.getSession(), (TableHandle)destinationTableHandle.get(), destinationColumnHandle).getType();
        if (!domainType.equals(redirectedType)) {
            ApplyTableScanRedirection.throwTypeMismatchException(destinationTable, destinationColumn, redirectedType, scanNode.getTable(), sourceColumnHandle, domainType);
        }
        symbol = context.getSymbolAllocator().newSymbol(destinationColumn, domainType);
        if (destinationColumnHandle == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find handle for column %s in destination table %s", destinationColumn, destinationTable));
        }
        newAssignmentsBuilder.put((Object)symbol, (Object)destinationColumnHandle);
        newOutputSymbolsBuilder.add((Object)symbol);
        return symbol;
    }
}

