/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import java.util.List;
import java.util.Set;

public class PruneCorrelatedJoinCorrelation
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin();

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        Set<Symbol> subquerySymbols = SymbolsExtractor.extractUnique(correlatedJoinNode.getSubquery(), context.getLookup());
        List newCorrelation = (List)correlatedJoinNode.getCorrelation().stream().filter(subquerySymbols::contains).collect(ImmutableList.toImmutableList());
        if (newCorrelation.size() < correlatedJoinNode.getCorrelation().size()) {
            return Rule.Result.ofPlanNode(new CorrelatedJoinNode(correlatedJoinNode.getId(), correlatedJoinNode.getInput(), correlatedJoinNode.getSubquery(), newCorrelation, correlatedJoinNode.getType(), correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery()));
        }
        return Rule.Result.empty();
    }
}

