/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushAggregationIntoTableScan;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.DistinctLimitNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PushDistinctLimitIntoTableScan
implements Rule<DistinctLimitNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<DistinctLimitNode> PATTERN = Patterns.distinctLimit().with(Patterns.DistinctLimit.isPartial().equalTo((Object)false)).with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;

    public PushDistinctLimitIntoTableScan(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<DistinctLimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    @Override
    public Rule.Result apply(DistinctLimitNode node, Captures captures, Rule.Context context) {
        Optional<PlanNode> result = PushAggregationIntoTableScan.pushAggregationIntoTableScan(this.metadata, context, (TableScanNode)captures.get(TABLE_SCAN), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), node.getDistinctSymbols());
        if (result.isEmpty()) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new LimitNode(node.getId(), result.get(), node.getLimit(), node.isPartial()));
    }
}

