/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.connector.GroupingProperty;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.LocalProperties;
import io.prestosql.sql.planner.optimizations.StreamPropertyDerivations;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.sanity.PlanSanityChecker;
import java.util.Iterator;
import java.util.Optional;

public class ValidateStreamingAggregations
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept(new Visitor(session, metadata, typeOperators, typeAnalyzer, types), null);
    }

    private static final class Visitor
    extends PlanVisitor<Void, Void> {
        private final Session session;
        private final Metadata metadata;
        private final TypeOperators typeOperators;
        private final TypeAnalyzer typeAnalyzer;
        private final TypeProvider types;

        private Visitor(Session session, Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer, TypeProvider types) {
            this.session = session;
            this.metadata = metadata;
            this.typeOperators = typeOperators;
            this.typeAnalyzer = typeAnalyzer;
            this.types = types;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            node.getSources().forEach(source -> source.accept(this, context));
            return null;
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            if (node.getPreGroupedSymbols().isEmpty()) {
                return null;
            }
            StreamPropertyDerivations.StreamProperties properties = StreamPropertyDerivations.derivePropertiesRecursively(node.getSource(), this.metadata, this.typeOperators, this.session, this.types, this.typeAnalyzer);
            ImmutableList desiredProperties = ImmutableList.of((Object)new GroupingProperty(node.getPreGroupedSymbols()));
            Iterator matchIterator = LocalProperties.match(properties.getLocalProperties(), desiredProperties).iterator();
            Optional unsatisfiedRequirement = (Optional)Iterators.getOnlyElement(matchIterator);
            Preconditions.checkArgument((boolean)unsatisfiedRequirement.isEmpty(), (Object)"Streaming aggregation with input not grouped on the grouping keys");
            return null;
        }
    }
}

