/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.rewrite;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.cost.CachingStatsProvider;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.security.GroupProvider;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.QueryUtil;
import io.prestosql.sql.analyzer.QueryExplainer;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.rewrite.StatementRewrite;
import io.prestosql.sql.tree.AllColumns;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.QueryBody;
import io.prestosql.sql.tree.QuerySpecification;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.Select;
import io.prestosql.sql.tree.SelectItem;
import io.prestosql.sql.tree.ShowStats;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.Table;
import io.prestosql.sql.tree.TableSubquery;
import io.prestosql.sql.tree.Values;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ShowStatsRewrite
implements StatementRewrite.Rewrite {
    private static final Expression NULL_DOUBLE = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)DoubleType.DOUBLE));
    private static final Expression NULL_VARCHAR = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR));

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, GroupProvider groupProvider, AccessControl accessControl, WarningCollector warningCollector, StatsCalculator statsCalculator) {
        return (Statement)new Visitor(session, parameters, queryExplainer, warningCollector, statsCalculator).process((Node)node, null);
    }

    private static Expression toDoubleLiteral(double value) {
        if (!Double.isFinite(value)) {
            return NULL_DOUBLE;
        }
        return new DoubleLiteral(Double.toString(value));
    }

    private static class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final List<Expression> parameters;
        private final Optional<QueryExplainer> queryExplainer;
        private final WarningCollector warningCollector;
        private final StatsCalculator statsCalculator;

        private Visitor(Session session, List<Expression> parameters, Optional<QueryExplainer> queryExplainer, WarningCollector warningCollector, StatsCalculator statsCalculator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parameters = Objects.requireNonNull(parameters, "parameters is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        }

        protected Node visitShowStats(ShowStats node, Void context) {
            Preconditions.checkState((boolean)this.queryExplainer.isPresent(), (Object)"Query explainer must be provided for SHOW STATS SELECT");
            Query query = this.getRelation(node);
            QuerySpecification specification = (QuerySpecification)query.getQueryBody();
            Plan plan = this.queryExplainer.get().getLogicalPlan(this.session, (Statement)QueryUtil.query((QueryBody)specification), this.parameters, this.warningCollector);
            CachingStatsProvider cachingStatsProvider = new CachingStatsProvider(this.statsCalculator, this.session, plan.getTypes());
            PlanNodeStatsEstimate stats = cachingStatsProvider.getStats(plan.getRoot());
            return this.rewriteShowStats(plan, stats);
        }

        private Query getRelation(ShowStats node) {
            if (node.getRelation() instanceof Table) {
                return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)node.getRelation());
            }
            if (node.getRelation() instanceof TableSubquery) {
                return ((TableSubquery)node.getRelation()).getQuery();
            }
            throw new IllegalArgumentException("Expected either TableSubquery or Table as relation");
        }

        private Node rewriteShowStats(Plan plan, PlanNodeStatsEstimate planNodeStatsEstimate) {
            List<String> statsColumnNames = Visitor.buildColumnsNames();
            List<SelectItem> selectItems = Visitor.buildSelectItems(statsColumnNames);
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            Verify.verify((boolean)(plan.getRoot() instanceof OutputNode), (String)"Expected plan root be OutputNode, but was: %s", (Object)plan.getRoot().getClass().getName());
            OutputNode root = (OutputNode)plan.getRoot();
            for (int columnIndex = 0; columnIndex < root.getOutputSymbols().size(); ++columnIndex) {
                Symbol outputSymbol = root.getOutputSymbols().get(columnIndex);
                String columnName = root.getColumnNames().get(columnIndex);
                Type columnType = plan.getTypes().get(outputSymbol);
                SymbolStatsEstimate symbolStatistics = planNodeStatsEstimate.getSymbolStatistics(outputSymbol);
                ImmutableList.Builder rowValues = ImmutableList.builder();
                rowValues.add((Object)new StringLiteral(columnName));
                rowValues.add((Object)ShowStatsRewrite.toDoubleLiteral(symbolStatistics.getAverageRowSize() * planNodeStatsEstimate.getOutputRowCount() * (1.0 - symbolStatistics.getNullsFraction())));
                rowValues.add((Object)ShowStatsRewrite.toDoubleLiteral(symbolStatistics.getDistinctValuesCount()));
                rowValues.add((Object)ShowStatsRewrite.toDoubleLiteral(symbolStatistics.getNullsFraction()));
                rowValues.add((Object)NULL_DOUBLE);
                rowValues.add((Object)Visitor.toStringLiteral(columnType, symbolStatistics.getLowValue()));
                rowValues.add((Object)Visitor.toStringLiteral(columnType, symbolStatistics.getHighValue()));
                rowsBuilder.add((Object)new Row((List)rowValues.build()));
            }
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)ShowStatsRewrite.toDoubleLiteral(planNodeStatsEstimate.getOutputRowCount()));
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_VARCHAR);
            rowsBuilder.add((Object)new Row((List)rowValues.build()));
            ImmutableList resultRows = rowsBuilder.build();
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll(selectItems), (Relation)QueryUtil.aliased((Relation)new Values((List)resultRows), (String)"table_stats", statsColumnNames));
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }

        private static List<String> buildColumnsNames() {
            return ImmutableList.builder().add((Object)"column_name").add((Object)"data_size").add((Object)"distinct_values_count").add((Object)"nulls_fraction").add((Object)"row_count").add((Object)"low_value").add((Object)"high_value").build();
        }

        private static List<SelectItem> buildSelectItems(List<String> columnNames) {
            return (List)columnNames.stream().map(QueryUtil::unaliasedName).collect(ImmutableList.toImmutableList());
        }

        private static Expression toStringLiteral(Type type, double value) {
            if (!Double.isFinite(value)) {
                return NULL_VARCHAR;
            }
            if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
                return new StringLiteral(Long.toString(Math.round(value)));
            }
            if (type.equals(DoubleType.DOUBLE) || type instanceof DecimalType) {
                return new StringLiteral(Double.toString(value));
            }
            if (type.equals(RealType.REAL)) {
                return new StringLiteral(Float.toString((float)value));
            }
            if (type.equals(DateType.DATE)) {
                return new StringLiteral(LocalDate.ofEpochDay(Math.round(value)).toString());
            }
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
    }
}

