/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.client.IntervalDayTime;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;

public final class IntervalDayTimeOperators {
    private IntervalDayTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="interval day to second")
    public static long add(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByBigint(@SqlType(value="interval day to second") long left, @SqlType(value="bigint") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        if (Double.isNaN(right)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot multiply by double NaN");
        }
        return (long)((double)left * right);
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long bigintMultiply(@SqlType(value="bigint") long left, @SqlType(value="interval day to second") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long doubleMultiply(@SqlType(value="double") double left, @SqlType(value="interval day to second") long right) {
        if (Double.isNaN(left)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot multiply by double NaN");
        }
        return (long)(left * (double)right);
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="interval day to second")
    public static long divideByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        if (Double.isNaN(right) || right == 0.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Cannot divide by double %s", right));
        }
        return (long)((double)left / right);
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="interval day to second")
    public static long negate(@SqlType(value="interval day to second") long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(@SqlType(value="interval day to second") long value) {
        return Slices.utf8Slice((String)IntervalDayTime.formatMillis((long)value));
    }
}

