/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpAddressOperators {
    private IpAddressOperators() {
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="ipaddress")
    public static Slice castFromVarcharToIpAddress(@SqlType(value="varchar(x)") Slice slice) {
        byte[] bytes;
        byte[] address;
        try {
            address = InetAddresses.forString((String)slice.toStringUtf8()).getAddress();
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast value to IPADDRESS: " + slice.toStringUtf8());
        }
        if (address.length == 4) {
            bytes = new byte[16];
            bytes[10] = -1;
            bytes[11] = -1;
            System.arraycopy(address, 0, bytes, 12, 4);
        } else if (address.length == 16) {
            bytes = address;
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid InetAddress length: " + address.length);
        }
        return Slices.wrappedBuffer((byte[])bytes);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castFromIpAddressToVarchar(@SqlType(value="ipaddress") Slice slice) {
        try {
            return Slices.utf8Slice((String)InetAddresses.toAddrString((InetAddress)InetAddress.getByAddress(slice.getBytes())));
        }
        catch (UnknownHostException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Invalid IP address binary length: " + slice.length(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="ipaddress")
    public static Slice castFromVarbinaryToIpAddress(@SqlType(value="varbinary") Slice slice) {
        if (slice.length() == 4) {
            byte[] address = slice.getBytes();
            byte[] bytes = new byte[16];
            bytes[10] = -1;
            bytes[11] = -1;
            System.arraycopy(address, 0, bytes, 12, 4);
            return Slices.wrappedBuffer((byte[])bytes);
        }
        if (slice.length() == 16) {
            return slice;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Invalid IP address binary length: " + slice.length());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varbinary")
    public static Slice castFromIpAddressToVarbinary(@SqlType(value="ipaddress") Slice slice) {
        return Slices.wrappedBuffer((byte[])slice.getBytes());
    }
}

