/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import java.util.UUID;

public final class UuidOperators {
    private UuidOperators() {
    }

    @Description(value="Generates a random UUID")
    @ScalarFunction(deterministic=false)
    @SqlType(value="uuid")
    public static Slice uuid() {
        UUID uuid = UUID.randomUUID();
        return Slices.wrappedLongArray((long[])new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()});
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="uuid")
    public static Slice castFromVarcharToUuid(@SqlType(value="varchar(x)") Slice slice) {
        try {
            UUID uuid = UUID.fromString(slice.toStringUtf8());
            if (slice.length() == 36) {
                return Slices.wrappedLongArray((long[])new long[]{Long.reverseBytes(uuid.getMostSignificantBits()), Long.reverseBytes(uuid.getLeastSignificantBits())});
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Invalid UUID string length: " + slice.length());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast value to UUID: " + slice.toStringUtf8());
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castFromUuidToVarchar(@SqlType(value="uuid") Slice slice) {
        long high = Long.reverseBytes(slice.getLong(0));
        long low = Long.reverseBytes(slice.getLong(8));
        return Slices.utf8Slice((String)new UUID(high, low).toString());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="uuid")
    public static Slice castFromVarbinaryToUuid(@SqlType(value="varbinary") Slice slice) {
        if (slice.length() == 16) {
            return slice;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Invalid UUID binary length: " + slice.length());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varbinary")
    public static Slice castFromUuidToVarbinary(@SqlType(value="uuid") Slice slice) {
        return Slices.wrappedBuffer((byte[])slice.getBytes());
    }
}

