/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;

public final class VarcharOperators {
    private VarcharOperators() {
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="varchar(x)") Slice value) {
        if (value.length() == 1) {
            byte character = VarcharOperators.toUpperCase(value.getByte(0));
            if (character == 84 || character == 49) {
                return true;
            }
            if (character == 70 || character == 48) {
                return false;
            }
        }
        if (value.length() == 4 && VarcharOperators.toUpperCase(value.getByte(0)) == 84 && VarcharOperators.toUpperCase(value.getByte(1)) == 82 && VarcharOperators.toUpperCase(value.getByte(2)) == 85 && VarcharOperators.toUpperCase(value.getByte(3)) == 69) {
            return true;
        }
        if (value.length() == 5 && VarcharOperators.toUpperCase(value.getByte(0)) == 70 && VarcharOperators.toUpperCase(value.getByte(1)) == 65 && VarcharOperators.toUpperCase(value.getByte(2)) == 76 && VarcharOperators.toUpperCase(value.getByte(3)) == 83 && VarcharOperators.toUpperCase(value.getByte(4)) == 69) {
            return false;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to BOOLEAN", value.toStringUtf8()));
    }

    private static byte toUpperCase(byte b) {
        return VarcharOperators.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    private static boolean isLowerCase(byte b) {
        return b >= 97 && b <= 122;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="varchar(x)") Slice slice) {
        try {
            return Double.parseDouble(slice.toStringUtf8());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to DOUBLE", slice.toStringUtf8()));
        }
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="real")
    public static long castToFloat(@SqlType(value="varchar(x)") Slice slice) {
        try {
            return Float.floatToIntBits(Float.parseFloat(slice.toStringUtf8()));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to REAL", slice.toStringUtf8()));
        }
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="varchar(x)") Slice slice) {
        try {
            return Long.parseLong(slice.toStringUtf8());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to BIGINT", slice.toStringUtf8()));
        }
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="varchar(x)") Slice slice) {
        try {
            return Integer.parseInt(slice.toStringUtf8());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to INT", slice.toStringUtf8()));
        }
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="varchar(x)") Slice slice) {
        try {
            return Short.parseShort(slice.toStringUtf8());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to SMALLINT", slice.toStringUtf8()));
        }
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="varchar(x)") Slice slice) {
        try {
            return Byte.parseByte(slice.toStringUtf8());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to TINYINT", slice.toStringUtf8()));
        }
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varbinary")
    public static Slice castToBinary(@SqlType(value="varchar(x)") Slice slice) {
        return slice;
    }
}

