/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import com.google.common.base.Preconditions;
import org.openjdk.jol.info.ClassLayout;

public class HeapTraversal {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(HeapTraversal.class).instanceSize();
    private static final long TOP_BIT_MASK = Long.MIN_VALUE;
    private long shifted;
    private int treeDepthToNode;

    public void resetWithPathTo(long targetNodeIndex) {
        Preconditions.checkArgument((targetNodeIndex >= 1L ? 1 : 0) != 0, (Object)"Target node index must be greater than or equal to one");
        int leadingZeros = Long.numberOfLeadingZeros(targetNodeIndex);
        this.shifted = targetNodeIndex << leadingZeros + 1;
        this.treeDepthToNode = 64 - (leadingZeros + 1);
    }

    public boolean isTarget() {
        return this.treeDepthToNode == 0;
    }

    public Child nextChild() {
        Preconditions.checkState((!this.isTarget() ? 1 : 0) != 0, (Object)"Already at target");
        Child childToFollow = (this.shifted & Long.MIN_VALUE) == 0L ? Child.LEFT : Child.RIGHT;
        this.shifted <<= 1;
        --this.treeDepthToNode;
        return childToFollow;
    }

    public long sizeOf() {
        return INSTANCE_SIZE;
    }

    public static enum Child {
        LEFT,
        RIGHT;

    }
}

