/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jmx;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.base.jmx.MBeanServerModule;
import io.prestosql.plugin.jmx.JmxConnector;
import io.prestosql.plugin.jmx.JmxConnectorConfig;
import io.prestosql.plugin.jmx.JmxHandleResolver;
import io.prestosql.plugin.jmx.JmxHistoricalData;
import io.prestosql.plugin.jmx.JmxMetadata;
import io.prestosql.plugin.jmx.JmxPeriodicSampler;
import io.prestosql.plugin.jmx.JmxRecordSetProvider;
import io.prestosql.plugin.jmx.JmxSplitManager;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import java.util.Map;

public class JmxConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "jmx";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new JmxHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Bootstrap app = new Bootstrap(new Module[]{new MBeanServerModule(), binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(JmxConnectorConfig.class);
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
            binder.bind(JmxConnector.class).in(Scopes.SINGLETON);
            binder.bind(JmxHistoricalData.class).in(Scopes.SINGLETON);
            binder.bind(JmxMetadata.class).in(Scopes.SINGLETON);
            binder.bind(JmxSplitManager.class).in(Scopes.SINGLETON);
            binder.bind(JmxPeriodicSampler.class).in(Scopes.SINGLETON);
            binder.bind(JmxRecordSetProvider.class).in(Scopes.SINGLETON);
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(JmxConnector.class);
    }
}

