/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jmx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.prestosql.plugin.jmx.JmxColumnHandle;
import io.prestosql.plugin.jmx.JmxSplit;
import io.prestosql.plugin.jmx.JmxTableHandle;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.FixedSplitSource;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class JmxSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;

    @Inject
    public JmxSplitManager(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        JmxTableHandle tableHandle = (JmxTableHandle)table;
        Optional<JmxColumnHandle> nodeColumnHandle = tableHandle.getColumnHandles().stream().filter(jmxColumnHandle -> jmxColumnHandle.getColumnName().equals("node")).findFirst();
        Preconditions.checkState((boolean)nodeColumnHandle.isPresent(), (String)"Failed to find %s column", (Object)"node");
        TupleDomain<ColumnHandle> nodeFilter = tableHandle.getNodeFilter();
        List splits = this.nodeManager.getAllNodes().stream().filter(node -> {
            NullableValue value = NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)node.getNodeIdentifier()));
            return nodeFilter.overlaps(TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)((ColumnHandle)nodeColumnHandle.get()), (Object)value)));
        }).map(node -> new JmxSplit((List<HostAddress>)ImmutableList.of((Object)node.getHostAndPort()))).collect(Collectors.toList());
        return new FixedSplitSource(splits);
    }
}

