/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached;

import datomic.spy.memcached.CASMutation;
import datomic.spy.memcached.CASResponse;
import datomic.spy.memcached.CASValue;
import datomic.spy.memcached.MemcachedClientIF;
import datomic.spy.memcached.compat.SpyObject;
import datomic.spy.memcached.transcoders.Transcoder;

public class CASMutator<T>
extends SpyObject {
    private static final int MAX_TRIES = 8192;
    private final MemcachedClientIF client;
    private final Transcoder<T> transcoder;
    private final int max;

    public CASMutator(MemcachedClientIF c, Transcoder<T> tc, int maxTries) {
        this.client = c;
        this.transcoder = tc;
        this.max = maxTries;
    }

    public CASMutator(MemcachedClientIF c, Transcoder<T> tc) {
        this(c, tc, 8192);
    }

    public T cas(String key, T initial, int initialExp, CASMutation<T> m) throws Exception {
        T rv = initial;
        boolean done = false;
        for (int i = 0; !done && i < this.max; ++i) {
            CASValue<T> casval = this.client.gets(key, this.transcoder);
            Object current = null;
            if (casval != null) {
                T tmp = casval.getValue();
                current = tmp;
            }
            if (current != null) {
                assert (casval != null) : "casval was null with a current value";
                rv = m.getNewValue(current);
                if (this.client.cas(key, casval.getCas(), initialExp, rv, this.transcoder) != CASResponse.OK) continue;
                done = true;
                continue;
            }
            if (initial == null) {
                done = true;
                rv = null;
                continue;
            }
            if (!this.client.add(key, initialExp, initial, this.transcoder).get().booleanValue()) continue;
            done = true;
            rv = initial;
        }
        if (!done) {
            throw new RuntimeException("Couldn't get a CAS in " + this.max + " attempts");
        }
        return rv;
    }
}

