/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached;

import datomic.spy.memcached.BinaryConnectionFactory;
import datomic.spy.memcached.BroadcastOpFactory;
import datomic.spy.memcached.ConnectionFactory;
import datomic.spy.memcached.ConnectionObserver;
import datomic.spy.memcached.MemcachedConnection;
import datomic.spy.memcached.MemcachedNode;
import datomic.spy.memcached.OperationFactory;
import datomic.spy.memcached.auth.AuthDescriptor;
import datomic.spy.memcached.auth.AuthThreadMonitor;
import datomic.spy.memcached.compat.SpyObject;
import datomic.spy.memcached.ops.Operation;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.OperationStatus;
import datomic.spy.memcached.transcoders.TranscodeService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TapConnectionProvider
extends SpyObject
implements ConnectionObserver {
    protected volatile boolean shuttingDown = false;
    protected final MemcachedConnection conn;
    protected final OperationFactory opFact;
    protected final TranscodeService tcService;
    protected final AuthDescriptor authDescriptor;
    protected final AuthThreadMonitor authMonitor = new AuthThreadMonitor();

    public TapConnectionProvider(InetSocketAddress ... ia) throws IOException {
        this(new BinaryConnectionFactory(), Arrays.asList(ia));
    }

    public TapConnectionProvider(List<InetSocketAddress> addrs) throws IOException {
        this(new BinaryConnectionFactory(), addrs);
    }

    public TapConnectionProvider(ConnectionFactory cf, List<InetSocketAddress> addrs) throws IOException {
        if (cf == null) {
            throw new NullPointerException("Connection factory required");
        }
        if (addrs == null) {
            throw new NullPointerException("Server list required");
        }
        if (addrs.isEmpty()) {
            throw new IllegalArgumentException("You must have at least one server to connect to");
        }
        if (cf.getOperationTimeout() <= 0L) {
            throw new IllegalArgumentException("Operation timeout must be positive.");
        }
        this.tcService = new TranscodeService(cf.isDaemon());
        cf.getDefaultTranscoder();
        this.opFact = cf.getOperationFactory();
        assert (this.opFact != null) : "Connection factory failed to make op factory";
        this.conn = cf.createConnection(addrs);
        assert (this.conn != null) : "Connection factory failed to make a connection";
        this.authDescriptor = cf.getAuthDescriptor();
        if (this.authDescriptor != null) {
            this.addObserver(this);
        }
    }

    public void addTapAckOp(MemcachedNode node, Operation op) {
        this.conn.addOperation(node, op);
    }

    public CountDownLatch broadcastOp(BroadcastOpFactory of) {
        if (this.shuttingDown) {
            throw new IllegalStateException("Shutting down");
        }
        return this.conn.broadcastOperation(of, this.conn.getLocator().getAll());
    }

    public boolean addObserver(ConnectionObserver obs) {
        boolean rv = this.conn.addObserver(obs);
        if (rv) {
            for (MemcachedNode node : this.conn.getLocator().getAll()) {
                if (!node.isActive()) continue;
                obs.connectionEstablished(node.getSocketAddress(), -1);
            }
        }
        return rv;
    }

    public boolean removeObserver(ConnectionObserver obs) {
        return this.conn.removeObserver(obs);
    }

    @Override
    public void connectionEstablished(SocketAddress sa, int reconnectCount) {
        if (this.authDescriptor != null) {
            if (this.authDescriptor.authThresholdReached()) {
                this.shutdown();
            } else {
                this.authMonitor.authConnection(this.conn, this.opFact, this.authDescriptor, this.findNode(sa));
            }
        }
    }

    private MemcachedNode findNode(SocketAddress sa) {
        MemcachedNode node = null;
        for (MemcachedNode n : this.conn.getLocator().getAll()) {
            if (!n.getSocketAddress().equals(sa)) continue;
            node = n;
        }
        assert (node != null) : "Couldn't find node connected to " + sa;
        return node;
    }

    @Override
    public void connectionLost(SocketAddress sa) {
    }

    public void shutdown() {
        this.shutdown(-1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(long timeout, TimeUnit unit) {
        if (this.shuttingDown) {
            this.getLogger().info("Suppressing duplicate attempt to shut down");
            return false;
        }
        this.shuttingDown = true;
        String baseName = this.conn.getName();
        this.conn.setName(baseName + " - SHUTTING DOWN");
        boolean rv = false;
        try {
            if (timeout > 0L) {
                this.conn.setName(baseName + " - SHUTTING DOWN (waiting)");
                rv = this.waitForQueues(timeout, unit);
            }
        }
        finally {
            try {
                this.conn.setName(baseName + " - SHUTTING DOWN (telling client)");
                this.conn.shutdown();
                this.conn.setName(baseName + " - SHUTTING DOWN (informed client)");
                this.tcService.shutdown();
            }
            catch (IOException e) {
                this.getLogger().warn((Object)"exception while shutting down", e);
            }
        }
        return rv;
    }

    public boolean waitForQueues(long timeout, TimeUnit unit) {
        CountDownLatch blatch = this.broadcastOp(new BroadcastOpFactory(){

            @Override
            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                return TapConnectionProvider.this.opFact.noop(new OperationCallback(){

                    @Override
                    public void complete() {
                        latch.countDown();
                    }

                    @Override
                    public void receivedStatus(OperationStatus s) {
                    }
                });
            }
        }, this.conn.getLocator().getAll(), false);
        try {
            return blatch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for queues", e);
        }
    }

    private CountDownLatch broadcastOp(BroadcastOpFactory of, Collection<MemcachedNode> nodes, boolean checkShuttingDown) {
        if (checkShuttingDown && this.shuttingDown) {
            throw new IllegalStateException("Shutting down");
        }
        return this.conn.broadcastOperation(of, nodes);
    }

    public OperationFactory getOpFactory() {
        return this.opFact;
    }
}

