/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.internal;

import datomic.spy.memcached.internal.AbstractListenableFuture;
import datomic.spy.memcached.internal.GetCompletionListener;
import datomic.spy.memcached.internal.OperationFuture;
import datomic.spy.memcached.ops.Operation;
import datomic.spy.memcached.ops.OperationStatus;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GetFuture<T>
extends AbstractListenableFuture<T, GetCompletionListener>
implements Future<T> {
    private final OperationFuture<Future<T>> rv;

    public GetFuture(CountDownLatch l, long opTimeout, String key, ExecutorService service) {
        super(service);
        this.rv = new OperationFuture(key, l, opTimeout, service);
    }

    @Override
    public boolean cancel(boolean ign) {
        boolean result = this.rv.cancel(ign);
        this.notifyListeners();
        return result;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Future<T> v = this.rv.get();
        return v == null ? null : (T)v.get();
    }

    @Override
    public T get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
        Future<T> v = this.rv.get(duration, units);
        return v == null ? null : (T)v.get();
    }

    public OperationStatus getStatus() {
        return this.rv.getStatus();
    }

    public void set(Future<T> d, OperationStatus s) {
        this.rv.set(d, s);
    }

    public void setOperation(Operation to) {
        this.rv.setOperation(to);
    }

    @Override
    public boolean isCancelled() {
        return this.rv.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.rv.isDone();
    }

    @Override
    public GetFuture<T> addListener(GetCompletionListener listener) {
        super.addToListeners(listener);
        return this;
    }

    @Override
    public GetFuture<T> removeListener(GetCompletionListener listener) {
        super.removeFromListeners(listener);
        return this;
    }

    public void signalComplete() {
        this.notifyListeners();
    }
}

