/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.ascii;

import datomic.spy.memcached.CASResponse;
import datomic.spy.memcached.KeyUtil;
import datomic.spy.memcached.ops.CASOperation;
import datomic.spy.memcached.ops.CASOperationStatus;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.OperationState;
import datomic.spy.memcached.ops.OperationStatus;
import datomic.spy.memcached.ops.StatusCode;
import datomic.spy.memcached.ops.StoreType;
import datomic.spy.memcached.protocol.ascii.OperationImpl;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

class CASOperationImpl
extends OperationImpl
implements CASOperation {
    private static final int OVERHEAD = 64;
    private static final OperationStatus STORED = new CASOperationStatus(true, "STORED", CASResponse.OK, StatusCode.SUCCESS);
    private static final OperationStatus NOT_FOUND = new CASOperationStatus(false, "NOT_FOUND", CASResponse.NOT_FOUND, StatusCode.ERR_NOT_FOUND);
    private static final OperationStatus EXISTS = new CASOperationStatus(false, "EXISTS", CASResponse.EXISTS, StatusCode.ERR_EXISTS);
    private final String key;
    private final long casValue;
    private final int flags;
    private final int exp;
    private final byte[] data;

    public CASOperationImpl(String k, long c, int f, int e, byte[] d, OperationCallback cb) {
        super(cb);
        this.key = k;
        this.casValue = c;
        this.flags = f;
        this.exp = e;
        this.data = d;
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        this.getCallback().receivedStatus(this.matchStatus(line, STORED, NOT_FOUND, EXISTS));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer bb = ByteBuffer.allocate(this.data.length + KeyUtil.getKeyBytes(this.key).length + 64);
        this.setArguments(bb, "cas", this.key, this.flags, this.exp, this.data.length, this.casValue);
        assert (bb.remaining() >= this.data.length + 2) : "Not enough room in buffer, need another " + (2 + this.data.length - bb.remaining());
        bb.put(this.data);
        bb.put(CRLF);
        bb.flip();
        this.setBuffer(bb);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public long getCasValue() {
        return this.casValue;
    }

    @Override
    public int getExpiration() {
        return this.exp;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public StoreType getStoreType() {
        return StoreType.set;
    }

    public String toString() {
        return "Cmd: cas Key: " + this.key + " Cas Value: " + this.casValue + " Flags: " + this.flags + " Exp: " + this.exp + " Data Length: " + this.data.length;
    }
}

