/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.ascii;

import datomic.spy.memcached.KeyUtil;
import datomic.spy.memcached.ops.Mutator;
import datomic.spy.memcached.ops.MutatorOperation;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.OperationState;
import datomic.spy.memcached.ops.OperationStatus;
import datomic.spy.memcached.ops.StatusCode;
import datomic.spy.memcached.protocol.ascii.OperationImpl;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

final class MutatorOperationImpl
extends OperationImpl
implements MutatorOperation {
    public static final int OVERHEAD = 32;
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND", StatusCode.ERR_NOT_FOUND);
    private final Mutator mutator;
    private final String key;
    private final long amount;

    public MutatorOperationImpl(Mutator m, String k, long amt, OperationCallback c) {
        super(c);
        this.mutator = m;
        this.key = k;
        this.amount = amt;
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Result:  %s", line);
        OperationStatus found = null;
        found = line.equals("NOT_FOUND") ? NOT_FOUND : new OperationStatus(true, line, StatusCode.SUCCESS);
        this.getCallback().receivedStatus(found);
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        int size = KeyUtil.getKeyBytes(this.key).length + 32;
        ByteBuffer b = ByteBuffer.allocate(size);
        this.setArguments(b, this.mutator.name(), this.key, this.amount);
        b.flip();
        this.setBuffer(b);
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public long getBy() {
        return this.amount;
    }

    @Override
    public long getDefault() {
        return -1L;
    }

    @Override
    public int getExpiration() {
        return -1;
    }

    @Override
    public Mutator getType() {
        return this.mutator;
    }

    public String toString() {
        return "Cmd: " + this.mutator.name() + " Key: " + this.key + " Amount: " + this.amount;
    }
}

