/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.ascii;

import datomic.spy.memcached.KeyUtil;
import datomic.spy.memcached.ops.ConfigurationType;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.OperationState;
import datomic.spy.memcached.ops.OperationStatus;
import datomic.spy.memcached.ops.SetConfigOperation;
import datomic.spy.memcached.protocol.ascii.OperationImpl;
import java.nio.ByteBuffer;

class SetConfigOperationImpl
extends OperationImpl
implements SetConfigOperation {
    private static final String CMD = "config set";
    private static final int OVERHEAD = 32;
    private static final OperationStatus STORED = new OperationStatus(true, "STORED");
    protected final ConfigurationType type;
    protected final int flags;
    protected final byte[] data;

    public SetConfigOperationImpl(ConfigurationType type, int f, byte[] d, OperationCallback cb) {
        super(cb);
        this.type = type;
        this.flags = f;
        this.data = d;
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        this.getCallback().receivedStatus(this.matchStatus(line, STORED));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer bb = ByteBuffer.allocate(this.data.length + KeyUtil.getKeyBytes(this.type.getValue()).length + 32);
        this.setArguments(bb, CMD, this.type.getValue(), this.flags, this.data.length);
        assert (bb.remaining() >= this.data.length + 2) : "Not enough room in buffer, need another " + (2 + this.data.length - bb.remaining());
        bb.put(this.data);
        bb.put(CRLF);
        bb.flip();
        this.setBuffer(bb);
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public ConfigurationType getType() {
        return this.type;
    }

    public String toString() {
        return "Cmd: config set Type: " + this.type.getValue() + " Flags: " + this.flags + " Data Length: " + this.data.length;
    }
}

