/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.ascii;

import datomic.spy.memcached.KeyUtil;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.OperationState;
import datomic.spy.memcached.ops.OperationStatus;
import datomic.spy.memcached.ops.StatusCode;
import datomic.spy.memcached.ops.TouchOperation;
import datomic.spy.memcached.protocol.ascii.OperationImpl;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

final class TouchOperationImpl
extends OperationImpl
implements TouchOperation {
    private static final int OVERHEAD = 9;
    private static final OperationStatus OK = new OperationStatus(true, "TOUCHED", StatusCode.SUCCESS);
    private final String key;
    private final int exp;

    public TouchOperationImpl(String k, int t, OperationCallback cb) {
        super(cb);
        this.key = k;
        this.exp = t;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Touch completed successfully");
        this.getCallback().receivedStatus(this.matchStatus(line, OK));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer b = null;
        b = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + String.valueOf(this.exp).length() + 9);
        b.put(("touch " + this.key + " " + this.exp + "\r\n").getBytes());
        b.flip();
        this.setBuffer(b);
    }

    @Override
    public int getExpiration() {
        return this.exp;
    }

    public String toString() {
        return "Cmd: touch key: " + this.key + " exp: " + this.exp;
    }
}

