/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.ascii;

import datomic.spy.memcached.KeyUtil;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.OperationState;
import datomic.spy.memcached.ops.OperationStatus;
import datomic.spy.memcached.ops.StatusCode;
import datomic.spy.memcached.ops.UnlockOperation;
import datomic.spy.memcached.protocol.ascii.OperationImpl;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

final class UnlockOperationImpl
extends OperationImpl
implements UnlockOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus UNLOCKED = new OperationStatus(true, "UNLOCKED", StatusCode.SUCCESS);
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND", StatusCode.ERR_NOT_FOUND);
    private static final String CMD = "unl";
    private final String key;
    private final long cas;

    public UnlockOperationImpl(String k, long casId, OperationCallback cb) {
        super(cb);
        this.key = k;
        this.cas = casId;
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Unlock of %s returned %s", this.key, line);
        this.getCallback().receivedStatus(this.matchStatus(line, UNLOCKED, NOT_FOUND));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer b = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + 32);
        this.setArguments(b, CMD, this.key, this.cas);
        b.flip();
        this.setBuffer(b);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    public String toString() {
        return "Cmd: unl Key: " + this.key + " Cas Value: " + this.cas;
    }
}

