/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.binary;

import datomic.spy.memcached.ops.BaseOperationFactory;
import datomic.spy.memcached.ops.CASOperation;
import datomic.spy.memcached.ops.ConcatenationOperation;
import datomic.spy.memcached.ops.ConcatenationType;
import datomic.spy.memcached.ops.ConfigurationType;
import datomic.spy.memcached.ops.DeleteConfigOperation;
import datomic.spy.memcached.ops.DeleteOperation;
import datomic.spy.memcached.ops.FlushOperation;
import datomic.spy.memcached.ops.GetAndTouchOperation;
import datomic.spy.memcached.ops.GetConfigOperation;
import datomic.spy.memcached.ops.GetOperation;
import datomic.spy.memcached.ops.GetlOperation;
import datomic.spy.memcached.ops.GetsOperation;
import datomic.spy.memcached.ops.KeyedOperation;
import datomic.spy.memcached.ops.MultiGetOperationCallback;
import datomic.spy.memcached.ops.MultiGetsOperationCallback;
import datomic.spy.memcached.ops.MultiReplicaGetOperationCallback;
import datomic.spy.memcached.ops.Mutator;
import datomic.spy.memcached.ops.MutatorOperation;
import datomic.spy.memcached.ops.NoopOperation;
import datomic.spy.memcached.ops.ObserveOperation;
import datomic.spy.memcached.ops.Operation;
import datomic.spy.memcached.ops.OperationCallback;
import datomic.spy.memcached.ops.ReplicaGetOperation;
import datomic.spy.memcached.ops.ReplicaGetsOperation;
import datomic.spy.memcached.ops.SASLAuthOperation;
import datomic.spy.memcached.ops.SASLMechsOperation;
import datomic.spy.memcached.ops.SASLStepOperation;
import datomic.spy.memcached.ops.SetConfigOperation;
import datomic.spy.memcached.ops.StatsOperation;
import datomic.spy.memcached.ops.StoreOperation;
import datomic.spy.memcached.ops.StoreType;
import datomic.spy.memcached.ops.TapOperation;
import datomic.spy.memcached.ops.TouchOperation;
import datomic.spy.memcached.ops.UnlockOperation;
import datomic.spy.memcached.ops.VersionOperation;
import datomic.spy.memcached.protocol.binary.ConcatenationOperationImpl;
import datomic.spy.memcached.protocol.binary.DeleteConfigOperationImpl;
import datomic.spy.memcached.protocol.binary.DeleteOperationImpl;
import datomic.spy.memcached.protocol.binary.FlushOperationImpl;
import datomic.spy.memcached.protocol.binary.GetAndTouchOperationImpl;
import datomic.spy.memcached.protocol.binary.GetConfigOperationImpl;
import datomic.spy.memcached.protocol.binary.GetOperationImpl;
import datomic.spy.memcached.protocol.binary.GetlOperationImpl;
import datomic.spy.memcached.protocol.binary.GetsOperationImpl;
import datomic.spy.memcached.protocol.binary.KeyStatsOperationImpl;
import datomic.spy.memcached.protocol.binary.MultiGetOperationImpl;
import datomic.spy.memcached.protocol.binary.MutatorOperationImpl;
import datomic.spy.memcached.protocol.binary.NoopOperationImpl;
import datomic.spy.memcached.protocol.binary.ObserveOperationImpl;
import datomic.spy.memcached.protocol.binary.ReplicaGetOperationImpl;
import datomic.spy.memcached.protocol.binary.ReplicaGetsOperationImpl;
import datomic.spy.memcached.protocol.binary.SASLAuthOperationImpl;
import datomic.spy.memcached.protocol.binary.SASLMechsOperationImpl;
import datomic.spy.memcached.protocol.binary.SASLStepOperationImpl;
import datomic.spy.memcached.protocol.binary.SetConfigOperationImpl;
import datomic.spy.memcached.protocol.binary.StatsOperationImpl;
import datomic.spy.memcached.protocol.binary.StoreOperationImpl;
import datomic.spy.memcached.protocol.binary.TapAckOperationImpl;
import datomic.spy.memcached.protocol.binary.TapBackfillOperationImpl;
import datomic.spy.memcached.protocol.binary.TapCustomOperationImpl;
import datomic.spy.memcached.protocol.binary.TapDumpOperationImpl;
import datomic.spy.memcached.protocol.binary.TouchOperationImpl;
import datomic.spy.memcached.protocol.binary.UnlockOperationImpl;
import datomic.spy.memcached.protocol.binary.VersionOperationImpl;
import datomic.spy.memcached.tapmessage.RequestMessage;
import datomic.spy.memcached.tapmessage.TapOpcode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

public class BinaryOperationFactory
extends BaseOperationFactory {
    @Override
    public DeleteOperation delete(String key, DeleteOperation.Callback operationCallback) {
        return new DeleteOperationImpl(key, operationCallback);
    }

    @Override
    public DeleteOperation delete(String key, long cas, DeleteOperation.Callback operationCallback) {
        return new DeleteOperationImpl(key, cas, operationCallback);
    }

    @Override
    public UnlockOperation unlock(String key, long casId, OperationCallback cb) {
        return new UnlockOperationImpl(key, casId, cb);
    }

    @Override
    public ObserveOperation observe(String key, long casId, int index, ObserveOperation.Callback cb) {
        return new ObserveOperationImpl(key, casId, index, (OperationCallback)cb);
    }

    @Override
    public FlushOperation flush(int delay, OperationCallback cb) {
        return new FlushOperationImpl(cb);
    }

    @Override
    public GetAndTouchOperation getAndTouch(String key, int expiration, GetAndTouchOperation.Callback cb) {
        return new GetAndTouchOperationImpl(key, expiration, cb);
    }

    @Override
    public GetOperation get(String key, GetOperation.Callback callback) {
        return new GetOperationImpl(key, callback);
    }

    @Override
    public ReplicaGetOperation replicaGet(String key, int index, ReplicaGetOperation.Callback callback) {
        return new ReplicaGetOperationImpl(key, index, callback);
    }

    @Override
    public ReplicaGetsOperation replicaGets(String key, int index, ReplicaGetsOperation.Callback callback) {
        return new ReplicaGetsOperationImpl(key, index, callback);
    }

    @Override
    public GetOperation get(Collection<String> value, GetOperation.Callback cb) {
        return new MultiGetOperationImpl(value, cb);
    }

    @Override
    public GetlOperation getl(String key, int exp, GetlOperation.Callback cb) {
        return new GetlOperationImpl(key, exp, cb);
    }

    @Override
    public GetsOperation gets(String key, GetsOperation.Callback cb) {
        return new GetsOperationImpl(key, cb);
    }

    @Override
    public StatsOperation keyStats(String key, StatsOperation.Callback cb) {
        return new KeyStatsOperationImpl(key, cb);
    }

    @Override
    public GetConfigOperation getConfig(ConfigurationType type, GetConfigOperation.Callback callback) {
        return new GetConfigOperationImpl(type, callback);
    }

    @Override
    public SetConfigOperation setConfig(ConfigurationType type, int flags, byte[] data, OperationCallback cb) {
        return new SetConfigOperationImpl(type, flags, data, cb);
    }

    @Override
    public DeleteConfigOperation deleteConfig(ConfigurationType type, OperationCallback cb) {
        return new DeleteConfigOperationImpl(type, cb);
    }

    @Override
    public MutatorOperation mutate(Mutator m, String key, long by, long def, int exp, OperationCallback cb) {
        return new MutatorOperationImpl(m, key, by, def, exp, cb);
    }

    @Override
    public StatsOperation stats(String arg, StatsOperation.Callback cb) {
        return new StatsOperationImpl(arg, cb);
    }

    @Override
    public StoreOperation store(StoreType storeType, String key, int flags, int exp, byte[] data, StoreOperation.Callback cb) {
        return new StoreOperationImpl(storeType, key, flags, exp, data, 0L, cb);
    }

    @Override
    public TouchOperation touch(String key, int expiration, OperationCallback cb) {
        return new TouchOperationImpl(key, expiration, cb);
    }

    @Override
    public VersionOperation version(OperationCallback cb) {
        return new VersionOperationImpl(cb);
    }

    @Override
    public NoopOperation noop(OperationCallback cb) {
        return new NoopOperationImpl(cb);
    }

    @Override
    public CASOperation cas(StoreType type, String key, long casId, int flags, int exp, byte[] data, StoreOperation.Callback cb) {
        return new StoreOperationImpl(type, key, flags, exp, data, casId, cb);
    }

    @Override
    public ConcatenationOperation cat(ConcatenationType catType, long casId, String key, byte[] data, OperationCallback cb) {
        return new ConcatenationOperationImpl(catType, key, data, casId, cb);
    }

    @Override
    protected Collection<? extends Operation> cloneGet(KeyedOperation op) {
        ArrayList<KeyedOperation> rv = new ArrayList<KeyedOperation>();
        MultiGetOperationCallback getCb = null;
        MultiGetsOperationCallback getsCb = null;
        MultiReplicaGetOperationCallback replicaGetCb = null;
        if (op.getCallback() instanceof GetOperation.Callback) {
            getCb = new MultiGetOperationCallback(op.getCallback(), op.getKeys().size());
        } else if (op.getCallback() instanceof ReplicaGetOperation.Callback) {
            replicaGetCb = new MultiReplicaGetOperationCallback(op.getCallback(), op.getKeys().size());
        } else {
            getsCb = new MultiGetsOperationCallback(op.getCallback(), op.getKeys().size());
        }
        for (String k : op.getKeys()) {
            if (getCb != null) {
                rv.add(this.get(k, (GetOperation.Callback)getCb));
                continue;
            }
            if (getsCb != null) {
                rv.add(this.gets(k, getsCb));
                continue;
            }
            rv.add(this.replicaGet(k, ((ReplicaGetOperationImpl)op).getReplicaIndex(), replicaGetCb));
        }
        return rv;
    }

    @Override
    public SASLAuthOperation saslAuth(String[] mech, String serverName, Map<String, ?> props, CallbackHandler cbh, OperationCallback cb) {
        return new SASLAuthOperationImpl(mech, serverName, props, cbh, cb);
    }

    @Override
    public SASLMechsOperation saslMechs(OperationCallback cb) {
        return new SASLMechsOperationImpl(cb);
    }

    @Override
    public SASLStepOperation saslStep(String[] mech, byte[] challenge, String serverName, Map<String, ?> props, CallbackHandler cbh, OperationCallback cb) {
        return new SASLStepOperationImpl(mech, challenge, serverName, props, cbh, cb);
    }

    @Override
    public TapOperation tapBackfill(String id, long date, OperationCallback cb) {
        return new TapBackfillOperationImpl(id, date, cb);
    }

    @Override
    public TapOperation tapCustom(String id, RequestMessage message, OperationCallback cb) {
        return new TapCustomOperationImpl(id, message, cb);
    }

    @Override
    public TapOperation tapAck(TapOpcode opcode, int opaque, OperationCallback cb) {
        return new TapAckOperationImpl(opcode, opaque, cb);
    }

    @Override
    public TapOperation tapDump(String id, OperationCallback cb) {
        return new TapDumpOperationImpl(id, cb);
    }
}

