/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.session.db;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.base.jmx.MBeanServerModule;
import io.prestosql.plugin.session.db.DbSessionPropertyManager;
import io.prestosql.plugin.session.db.DbSessionPropertyManagerModule;
import io.prestosql.spi.resourcegroups.SessionPropertyConfigurationManagerContext;
import io.prestosql.spi.session.SessionPropertyConfigurationManager;
import io.prestosql.spi.session.SessionPropertyConfigurationManagerFactory;
import java.util.Map;
import org.weakref.jmx.guice.MBeanModule;

public class DbSessionPropertyManagerFactory
implements SessionPropertyConfigurationManagerFactory {
    public String getName() {
        return "db";
    }

    public SessionPropertyConfigurationManager create(Map<String, String> config, SessionPropertyConfigurationManagerContext context) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new JsonModule(), new DbSessionPropertyManagerModule()});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (SessionPropertyConfigurationManager)injector.getInstance(DbSessionPropertyManager.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

