/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.localfile;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.localfile.LocalFileColumnHandle;
import io.prestosql.plugin.localfile.LocalFileErrorCode;
import io.prestosql.plugin.localfile.LocalFileTableHandle;
import io.prestosql.plugin.localfile.LocalFileTables;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public class LocalFileRecordCursor
implements RecordCursor {
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\t").trimResults();
    public static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private final int[] fieldToColumnIndex;
    private final HostAddress address;
    private final List<LocalFileColumnHandle> columns;
    private final FilesReader reader;
    private final boolean includeServer;
    private List<String> fields;

    public LocalFileRecordCursor(LocalFileTables localFileTables, List<LocalFileColumnHandle> columns, SchemaTableName tableName, HostAddress address, TupleDomain<LocalFileColumnHandle> predicate) {
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.address = Objects.requireNonNull(address, "address is null");
        this.fieldToColumnIndex = new int[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            LocalFileColumnHandle columnHandle = columns.get(i);
            this.fieldToColumnIndex[i] = columnHandle.getOrdinalPosition();
        }
        this.includeServer = LocalFileRecordCursor.isThisServerIncluded(address, predicate, localFileTables.getTable(tableName));
        this.reader = this.includeServer ? LocalFileRecordCursor.getFilesReader(localFileTables, predicate, tableName) : null;
    }

    private static boolean isThisServerIncluded(HostAddress address, TupleDomain<LocalFileColumnHandle> predicate, LocalFileTableHandle table) {
        if (table.getServerAddressColumn().isEmpty()) {
            return true;
        }
        Optional domains = predicate.getDomains();
        if (domains.isEmpty()) {
            return true;
        }
        Set serverAddressDomain = ((Map)domains.get()).entrySet().stream().filter(entry -> ((LocalFileColumnHandle)entry.getKey()).getOrdinalPosition() == table.getServerAddressColumn().getAsInt()).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (serverAddressDomain.isEmpty()) {
            return true;
        }
        for (Domain domain : serverAddressDomain) {
            if (!domain.includesNullableValue((Object)Slices.utf8Slice((String)address.toString()))) continue;
            return true;
        }
        return false;
    }

    private static FilesReader getFilesReader(LocalFileTables localFileTables, TupleDomain<LocalFileColumnHandle> predicate, SchemaTableName tableName) {
        LocalFileTableHandle table = localFileTables.getTable(tableName);
        List<File> fileNames = localFileTables.getFiles(tableName);
        try {
            return new FilesReader(table.getTimestampColumn(), fileNames.iterator(), predicate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columns.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columns.get(field).getColumnType();
    }

    public boolean advanceNextPosition() {
        if (!this.includeServer) {
            return false;
        }
        try {
            this.fields = this.reader.readFields();
            return this.fields != null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getFieldValue(int field) {
        Preconditions.checkState((this.fields != null ? 1 : 0) != 0, (Object)"Cursor has not been advanced yet");
        int columnIndex = this.fieldToColumnIndex[field];
        if (columnIndex == -1) {
            return this.address.toString();
        }
        if (columnIndex >= this.fields.size()) {
            return null;
        }
        return this.fields.get(columnIndex);
    }

    public boolean getBoolean(int field) {
        this.checkFieldType(field, new Type[]{BooleanType.BOOLEAN});
        return Boolean.parseBoolean(this.getFieldValue(field));
    }

    public long getLong(int field) {
        if (this.getType(field).equals(TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3))) {
            return LocalFileRecordCursor.parseTimestamp(this.getFieldValue(field));
        }
        this.checkFieldType(field, new Type[]{BigintType.BIGINT, IntegerType.INTEGER});
        return Long.parseLong(this.getFieldValue(field));
    }

    public double getDouble(int field) {
        this.checkFieldType(field, new Type[]{DoubleType.DOUBLE});
        return Double.parseDouble(this.getFieldValue(field));
    }

    public Slice getSlice(int field) {
        this.checkFieldType(field, new Type[]{VarcharType.createUnboundedVarcharType()});
        return Slices.utf8Slice((String)this.getFieldValue(field));
    }

    public Object getObject(int field) {
        throw new UnsupportedOperationException();
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columns.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        String fieldValue = this.getFieldValue(field);
        return "null".equals(fieldValue) || Strings.isNullOrEmpty((String)fieldValue);
    }

    private void checkFieldType(int field, Type ... expected) {
        Type actual = this.getType(field);
        for (Type type : expected) {
            if (!actual.equals(type)) continue;
            return;
        }
        String expectedTypes = Joiner.on((String)", ").join((Object[])expected);
        throw new IllegalArgumentException(String.format("Expected field %s to be type %s but is %s", field, expectedTypes, actual));
    }

    public void close() {
        this.reader.close();
    }

    private static long parseTimestamp(String value) {
        OffsetDateTime time = OffsetDateTime.parse(value, ISO_FORMATTER).plus(500L, ChronoUnit.MICROS).truncatedTo(ChronoUnit.MILLIS);
        long epochMillis = time.toInstant().toEpochMilli();
        int offsetMinutes = Math.toIntExact(TimeUnit.SECONDS.toMinutes(time.getOffset().getTotalSeconds()));
        return DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (int)offsetMinutes);
    }

    private static class FilesReader {
        private final Iterator<File> files;
        private final Optional<Domain> domain;
        private final OptionalInt timestampOrdinalPosition;
        private BufferedReader reader;

        public FilesReader(OptionalInt timestampOrdinalPosition, Iterator<File> files, TupleDomain<LocalFileColumnHandle> predicate) throws IOException {
            Objects.requireNonNull(files, "files is null");
            this.files = files;
            Objects.requireNonNull(predicate, "predicate is null");
            this.domain = FilesReader.getDomain(timestampOrdinalPosition, predicate);
            this.timestampOrdinalPosition = timestampOrdinalPosition;
            this.reader = this.createNextReader();
        }

        private static Optional<Domain> getDomain(OptionalInt timestampOrdinalPosition, TupleDomain<LocalFileColumnHandle> predicate) {
            Map domainMap;
            Set timestampDomain;
            Optional domains = predicate.getDomains();
            Domain domain = null;
            if (domains.isPresent() && timestampOrdinalPosition.isPresent() && !(timestampDomain = (domainMap = (Map)domains.get()).entrySet().stream().filter(entry -> ((LocalFileColumnHandle)entry.getKey()).getOrdinalPosition() == timestampOrdinalPosition.getAsInt()).map(Map.Entry::getValue).collect(Collectors.toSet())).isEmpty()) {
                domain = (Domain)Iterables.getOnlyElement(timestampDomain);
            }
            return Optional.ofNullable(domain);
        }

        private BufferedReader createNextReader() throws IOException {
            if (!this.files.hasNext()) {
                return null;
            }
            File file = this.files.next();
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStream in = FilesReader.isGZipped(file) ? new GZIPInputStream(fileInputStream) : fileInputStream;
            return new BufferedReader(new InputStreamReader(in));
        }

        public static boolean isGZipped(File file) {
            boolean bl;
            RandomAccessFile inputFile = new RandomAccessFile(file, "r");
            try {
                int magic = inputFile.read() & 0xFF | inputFile.read() << 8 & 0xFF00;
                bl = magic == 35615;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)LocalFileErrorCode.LOCAL_FILE_READ_ERROR, "Error reading file: " + file.getName(), (Throwable)e);
                }
            }
            inputFile.close();
            return bl;
        }

        public List<String> readFields() throws IOException {
            List fields = null;
            boolean newReader = false;
            while (fields == null) {
                if (this.reader == null) {
                    return null;
                }
                String line = this.reader.readLine();
                if (line != null) {
                    fields = LINE_SPLITTER.splitToList((CharSequence)line);
                    if (!newReader || this.meetsPredicate(fields)) {
                        return fields;
                    }
                }
                this.reader.close();
                this.reader = this.createNextReader();
                newReader = true;
            }
            return fields;
        }

        private boolean meetsPredicate(List<String> fields) {
            if (this.timestampOrdinalPosition.isEmpty() || this.domain.isEmpty()) {
                return true;
            }
            long timestamp = LocalFileRecordCursor.parseTimestamp(fields.get(this.timestampOrdinalPosition.getAsInt()));
            return this.domain.get().includesNullableValue((Object)timestamp);
        }

        public void close() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

