/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.localfile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;

public class LocalFileSplit
implements ConnectorSplit {
    private final HostAddress address;

    @JsonCreator
    public LocalFileSplit(@JsonProperty(value="address") HostAddress address) {
        this.address = Objects.requireNonNull(address, "address is null");
    }

    @JsonProperty
    public HostAddress getAddress() {
        return this.address;
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of((Object)this.address);
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).toString();
    }
}

