/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.search;

import com.datomic.lucene.index.IndexReader;
import com.datomic.lucene.index.Term;
import com.datomic.lucene.search.BooleanClause;
import com.datomic.lucene.search.BooleanQuery;
import com.datomic.lucene.search.ConstantScoreQuery;
import com.datomic.lucene.search.MultiTermQuery;
import com.datomic.lucene.search.Query;
import com.datomic.lucene.search.TermCollectingRewrite;
import com.datomic.lucene.search.TermQuery;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScoringRewrite<Q extends Query>
extends TermCollectingRewrite<Q> {
    public static final ScoringRewrite<BooleanQuery> SCORING_BOOLEAN_QUERY_REWRITE = new ScoringRewrite<BooleanQuery>(){

        @Override
        protected BooleanQuery getTopLevelQuery() {
            return new BooleanQuery(true);
        }

        @Override
        protected void addClause(BooleanQuery topLevel, Term term, float boost) {
            TermQuery tq = new TermQuery(term);
            tq.setBoost(boost);
            topLevel.add(tq, BooleanClause.Occur.SHOULD);
        }

        protected Object readResolve() {
            return SCORING_BOOLEAN_QUERY_REWRITE;
        }
    };
    public static final MultiTermQuery.RewriteMethod CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE = new MultiTermQuery.RewriteMethod(){

        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            BooleanQuery bq = SCORING_BOOLEAN_QUERY_REWRITE.rewrite(reader, query);
            if (bq.clauses().isEmpty()) {
                return bq;
            }
            ConstantScoreQuery result = new ConstantScoreQuery(bq);
            result.setBoost(query.getBoost());
            return result;
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE;
        }
    };

    public Q rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
        Object result = this.getTopLevelQuery();
        int[] size = new int[1];
        this.collectTerms(reader, query, new TermCollectingRewrite.TermCollector((Query)result, query, size){
            final /* synthetic */ Query val$result;
            final /* synthetic */ MultiTermQuery val$query;
            final /* synthetic */ int[] val$size;
            {
                this.val$result = query;
                this.val$query = multiTermQuery;
                this.val$size = nArray;
            }

            public boolean collect(Term t, float boost) throws IOException {
                ScoringRewrite.this.addClause(this.val$result, t, this.val$query.getBoost() * boost);
                this.val$size[0] = this.val$size[0] + 1;
                return true;
            }
        });
        query.incTotalNumberOfTerms(size[0]);
        return result;
    }
}

