/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.type;

import io.prestosql.plugin.base.type.AbstractPrestoTimestampEncoder;
import io.prestosql.plugin.base.type.DecodedTimestamp;
import io.prestosql.plugin.base.type.PrestoTimestampEncoderFactory;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Timestamps;
import org.joda.time.DateTimeZone;

class LongTimestampEncoder
extends AbstractPrestoTimestampEncoder<LongTimestamp> {
    LongTimestampEncoder(TimestampType type, DateTimeZone timeZone) {
        super(type, timeZone);
    }

    @Override
    public void write(DecodedTimestamp decodedTimestamp, BlockBuilder blockBuilder) {
        LongTimestamp timestamp = this.getTimestamp(decodedTimestamp);
        this.type.writeObject(blockBuilder, (Object)timestamp);
    }

    @Override
    public LongTimestamp getTimestamp(DecodedTimestamp decodedTimestamp) {
        long adjustedSeconds = decodedTimestamp.getEpochSeconds();
        if (this.timeZone != DateTimeZone.UTC) {
            adjustedSeconds = this.timeZone.convertUTCToLocal(adjustedSeconds * 1000L) / 1000L;
        }
        int precision = this.type.getPrecision();
        int nanosOfSecond = decodedTimestamp.getNanosOfSecond();
        if (precision < 9) {
            nanosOfSecond = (int)Timestamps.round((long)nanosOfSecond, (int)(9 - precision));
        }
        return PrestoTimestampEncoderFactory.longTimestamp(adjustedSeconds, (long)nanosOfSecond * 1000L);
    }
}

