/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.codehaus.commons.io.LineAndColumnTracker;
import org.codehaus.commons.nullanalysis.NotNullByDefault;

public final class Readers {
    private Readers() {
    }

    public static Reader onFirstChar(Reader in, final Runnable runnable) {
        return new FilterReader(in){
            private boolean hadChars;

            @Override
            public int read() throws IOException {
                this.aboutToRead();
                return super.read();
            }

            @Override
            @NotNullByDefault(value=false)
            public int read(char[] cbuf, int off, int len) throws IOException {
                this.aboutToRead();
                return super.read(cbuf, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                this.aboutToRead();
                return super.skip(n);
            }

            private void aboutToRead() {
                if (!this.hadChars) {
                    runnable.run();
                    this.hadChars = true;
                }
            }
        };
    }

    public static Reader trackLineAndColumn(Reader in, final LineAndColumnTracker tracker) {
        return new FilterReader(in){

            @Override
            public int read() throws IOException {
                int c = super.read();
                if (c >= 0) {
                    tracker.consume((char)c);
                }
                return c;
            }

            @Override
            @NotNullByDefault(value=false)
            public int read(char[] cbuf, int off, int len) throws IOException {
                if (len <= 0) {
                    return 0;
                }
                int c = this.read();
                if (c < 0) {
                    return -1;
                }
                cbuf[off] = (char)c;
                return 1;
            }

            @Override
            public long skip(long n) throws IOException {
                if (n <= 0L) {
                    return 0L;
                }
                int c = this.read();
                if (c < 0) {
                    return 0L;
                }
                return 1L;
            }

            @Override
            public boolean markSupported() {
                return false;
            }

            @Override
            public void mark(int readAheadLimit) throws IOException {
                throw new IOException();
            }

            @Override
            public void reset() throws IOException {
                throw new IOException();
            }
        };
    }
}

