/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.GrantOnType;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.PrincipalSpecification;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Grant
extends Statement {
    private final Optional<List<String>> privileges;
    private final Optional<GrantOnType> type;
    private final QualifiedName name;
    private final PrincipalSpecification grantee;
    private final boolean grantOption;

    public Grant(Optional<List<String>> privileges, Optional<GrantOnType> type, QualifiedName name, PrincipalSpecification grantee, boolean grantOption) {
        this(Optional.empty(), privileges, type, name, grantee, grantOption);
    }

    public Grant(NodeLocation location, Optional<List<String>> privileges, Optional<GrantOnType> type, QualifiedName name, PrincipalSpecification grantee, boolean grantOption) {
        this(Optional.of(location), privileges, type, name, grantee, grantOption);
    }

    private Grant(Optional<NodeLocation> location, Optional<List<String>> privileges, Optional<GrantOnType> type, QualifiedName name, PrincipalSpecification grantee, boolean grantOption) {
        super(location);
        Objects.requireNonNull(privileges, "privileges is null");
        this.privileges = privileges.map(ImmutableList::copyOf);
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
        this.grantOption = grantOption;
    }

    public Optional<List<String>> getPrivileges() {
        return this.privileges;
    }

    public Optional<GrantOnType> getType() {
        return this.type;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public PrincipalSpecification getGrantee() {
        return this.grantee;
    }

    public boolean isWithGrantOption() {
        return this.grantOption;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGrant(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.privileges, this.type, this.name, this.grantee, this.grantOption);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Grant o = (Grant)obj;
        return Objects.equals(this.privileges, o.privileges) && Objects.equals(this.type, o.type) && Objects.equals(this.name, o.name) && Objects.equals(this.grantee, o.grantee) && Objects.equals(this.grantOption, o.grantOption);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("privileges", this.privileges).add("type", this.type).add("name", (Object)this.name).add("grantee", (Object)this.grantee).add("grantOption", this.grantOption).toString();
    }
}

