/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.prestosql.plugin.memory.ColumnInfo;
import io.prestosql.plugin.memory.MemoryColumnHandle;
import io.prestosql.plugin.memory.MemoryDataFragment;
import io.prestosql.plugin.memory.MemoryInsertTableHandle;
import io.prestosql.plugin.memory.MemoryOutputTableHandle;
import io.prestosql.plugin.memory.MemoryTableHandle;
import io.prestosql.plugin.memory.TableInfo;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.LimitApplicationResult;
import io.prestosql.spi.connector.SampleType;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.ViewNotFoundException;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.statistics.ComputedStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class MemoryMetadata
implements ConnectorMetadata {
    public static final String SCHEMA_NAME = "default";
    private final NodeManager nodeManager;
    private final List<String> schemas = new ArrayList<String>();
    private final AtomicLong nextTableId = new AtomicLong();
    private final Map<SchemaTableName, Long> tableIds = new HashMap<SchemaTableName, Long>();
    private final Map<Long, TableInfo> tables = new HashMap<Long, TableInfo>();
    private final Map<SchemaTableName, ConnectorViewDefinition> views = new HashMap<SchemaTableName, ConnectorViewDefinition>();

    @Inject
    public MemoryMetadata(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.schemas.add(SCHEMA_NAME);
    }

    public synchronized List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.schemas);
    }

    public synchronized void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, PrestoPrincipal owner) {
        if (this.schemas.contains(schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Schema [%s] already exists", schemaName));
        }
        this.schemas.add(schemaName);
    }

    public synchronized void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.schemas.contains(schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Schema [%s] does not exist", schemaName));
        }
        boolean tablesExist = this.tables.values().stream().anyMatch(table -> table.getSchemaName().equals(schemaName));
        if (tablesExist) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        Verify.verify((boolean)this.schemas.remove(schemaName));
    }

    public Optional<PrestoPrincipal> getSchemaOwner(ConnectorSession session, CatalogSchemaName schemaName) {
        return Optional.empty();
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        return ImmutableMap.of();
    }

    public synchronized ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        Long id = this.tableIds.get(schemaTableName);
        if (id == null) {
            return null;
        }
        return new MemoryTableHandle(id);
    }

    public synchronized ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        return this.tables.get(handle.getId()).getMetadata();
    }

    public synchronized List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.views.keySet().stream().filter(table -> schemaName.map(table.getSchemaName()::contentEquals).orElse(true)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.tables.values().stream().filter(table -> schemaName.map(table.getSchemaName()::contentEquals).orElse(true)).map(TableInfo::getSchemaTableName).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public synchronized Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        return this.tables.get(handle.getId()).getColumns().stream().collect(Collectors.toMap(ColumnInfo::getName, ColumnInfo::getHandle));
    }

    public synchronized ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        return this.tables.get(handle.getId()).getColumn(columnHandle).getMetadata();
    }

    public synchronized Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return this.tables.values().stream().filter(table -> prefix.matches(table.getSchemaTableName())).collect(Collectors.toMap(TableInfo::getSchemaTableName, handle -> handle.getMetadata().getColumns()));
    }

    public synchronized void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        TableInfo info = this.tables.remove(handle.getId());
        if (info != null) {
            this.tableIds.remove(info.getSchemaTableName());
        }
    }

    public synchronized void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        this.checkSchemaExists(newTableName.getSchemaName());
        this.checkTableNotExists(newTableName);
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        long tableId = handle.getId();
        TableInfo oldInfo = this.tables.get(tableId);
        this.tables.put(tableId, new TableInfo(tableId, newTableName.getSchemaName(), newTableName.getTableName(), oldInfo.getColumns(), oldInfo.getDataFragments()));
        this.tableIds.remove(oldInfo.getSchemaTableName());
        this.tableIds.put(newTableName, tableId);
    }

    public synchronized void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        ConnectorOutputTableHandle outputTableHandle = this.beginCreateTable(session, tableMetadata, Optional.empty());
        this.finishCreateTable(session, outputTableHandle, (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public synchronized MemoryOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.checkSchemaExists(tableMetadata.getTable().getSchemaName());
        this.checkTableNotExists(tableMetadata.getTable());
        long tableId = this.nextTableId.getAndIncrement();
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No Memory nodes available");
        ImmutableList.Builder columns = ImmutableList.builder();
        for (int i = 0; i < tableMetadata.getColumns().size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableMetadata.getColumns().get(i);
            columns.add((Object)new ColumnInfo(new MemoryColumnHandle(i), column.getName(), column.getType()));
        }
        this.tableIds.put(tableMetadata.getTable(), tableId);
        this.tables.put(tableId, new TableInfo(tableId, tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), (List<ColumnInfo>)columns.build(), new HashMap<HostAddress, MemoryDataFragment>()));
        return new MemoryOutputTableHandle(tableId, (Set<Long>)ImmutableSet.copyOf(this.tableIds.values()));
    }

    private void checkSchemaExists(String schemaName) {
        if (!this.schemas.contains(schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
    }

    private void checkTableNotExists(SchemaTableName tableName) {
        if (this.tableIds.containsKey(tableName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Table [%s] already exists", tableName.toString()));
        }
        if (this.views.containsKey(tableName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("View [%s] already exists", tableName.toString()));
        }
    }

    public synchronized Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        MemoryOutputTableHandle memoryOutputHandle = (MemoryOutputTableHandle)tableHandle;
        this.updateRowsOnHosts(memoryOutputHandle.getTable(), fragments);
        return Optional.empty();
    }

    public synchronized MemoryInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns) {
        MemoryTableHandle memoryTableHandle = (MemoryTableHandle)tableHandle;
        return new MemoryInsertTableHandle(memoryTableHandle.getId(), (Set<Long>)ImmutableSet.copyOf(this.tableIds.values()));
    }

    public synchronized Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Objects.requireNonNull(insertHandle, "insertHandle is null");
        MemoryInsertTableHandle memoryInsertHandle = (MemoryInsertTableHandle)insertHandle;
        this.updateRowsOnHosts(memoryInsertHandle.getTable(), fragments);
        return Optional.empty();
    }

    public synchronized void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        this.checkSchemaExists(viewName.getSchemaName());
        if (this.tableIds.containsKey(viewName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists: " + viewName);
        }
        if (replace) {
            this.views.put(viewName, definition);
        } else if (this.views.putIfAbsent(viewName, definition) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + viewName);
        }
    }

    public synchronized void renameView(ConnectorSession session, SchemaTableName viewName, SchemaTableName newViewName) {
        this.checkSchemaExists(newViewName.getSchemaName());
        if (this.tableIds.containsKey(newViewName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists: " + newViewName);
        }
        if (this.views.containsKey(newViewName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + newViewName);
        }
        this.views.put(newViewName, this.views.remove(viewName));
    }

    public synchronized void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.views.remove(viewName) == null) {
            throw new ViewNotFoundException(viewName);
        }
    }

    public synchronized List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return (List)this.views.keySet().stream().filter(viewName -> schemaName.map(viewName.getSchemaName()::equals).orElse(true)).collect(ImmutableList.toImmutableList());
    }

    public synchronized Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        SchemaTablePrefix prefix = schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new);
        return ImmutableMap.copyOf((Map)Maps.filterKeys(this.views, arg_0 -> ((SchemaTablePrefix)prefix).matches(arg_0)));
    }

    public synchronized Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.ofNullable(this.views.get(viewName));
    }

    private void updateRowsOnHosts(long tableId, Collection<Slice> fragments) {
        TableInfo info = this.tables.get(tableId);
        Preconditions.checkState((info != null ? 1 : 0) != 0, (String)"Uninitialized tableId [%s.%s]", (Object)info.getSchemaName(), (Object)info.getTableName());
        HashMap<HostAddress, MemoryDataFragment> dataFragments = new HashMap<HostAddress, MemoryDataFragment>(info.getDataFragments());
        for (Slice fragment : fragments) {
            MemoryDataFragment memoryDataFragment = MemoryDataFragment.fromSlice(fragment);
            dataFragments.merge(memoryDataFragment.getHostAddress(), memoryDataFragment, MemoryDataFragment::merge);
        }
        this.tables.put(tableId, new TableInfo(tableId, info.getSchemaName(), info.getTableName(), info.getColumns(), dataFragments));
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public List<MemoryDataFragment> getDataFragments(long tableId) {
        return ImmutableList.copyOf(this.tables.get(tableId).getDataFragments().values());
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle handle, long limit) {
        MemoryTableHandle table = (MemoryTableHandle)handle;
        if (table.getLimit().isPresent() && table.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        return Optional.of(new LimitApplicationResult((Object)new MemoryTableHandle(table.getId(), OptionalLong.of(limit), OptionalDouble.empty()), true));
    }

    public Optional<ConnectorTableHandle> applySample(ConnectorSession session, ConnectorTableHandle handle, SampleType sampleType, double sampleRatio) {
        MemoryTableHandle table = (MemoryTableHandle)handle;
        if (table.getSampleRatio().isPresent() && table.getSampleRatio().getAsDouble() == sampleRatio || sampleType != SampleType.SYSTEM || table.getLimit().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new MemoryTableHandle(table.getId(), table.getLimit(), OptionalDouble.of(table.getSampleRatio().orElse(1.0) * sampleRatio)));
    }
}

