/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.spi.connector.ConnectorTableHandle;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public final class MemoryTableHandle
implements ConnectorTableHandle {
    private final long id;
    private final OptionalLong limit;
    private final OptionalDouble sampleRatio;

    public MemoryTableHandle(long id) {
        this(id, OptionalLong.empty(), OptionalDouble.empty());
    }

    @JsonCreator
    public MemoryTableHandle(@JsonProperty(value="id") long id, @JsonProperty(value="limit") OptionalLong limit, @JsonProperty(value="sampleRatio") OptionalDouble sampleRatio) {
        this.id = id;
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.sampleRatio = Objects.requireNonNull(sampleRatio, "sampleRatio is null");
    }

    @JsonProperty
    public long getId() {
        return this.id;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    @JsonProperty
    public OptionalDouble getSampleRatio() {
        return this.sampleRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryTableHandle that = (MemoryTableHandle)o;
        return this.id == that.id && this.limit.equals(that.limit) && this.sampleRatio.equals(that.sampleRatio);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.limit, this.sampleRatio);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id);
        this.limit.ifPresent(value -> builder.append("(limit:" + value + ")"));
        this.sampleRatio.ifPresent(value -> builder.append("(sampleRatio:" + value + ")"));
        return builder.toString();
    }
}

