/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.Runbook;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class RunbookMarshaller {
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<String> TARGETPARAMETERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetParameterName").build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").build();
    private static final MarshallingInfo<List> TARGETMAPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetMaps").build();
    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").build();
    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").build();
    private static final MarshallingInfo<List> TARGETLOCATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetLocations").build();
    private static final RunbookMarshaller instance = new RunbookMarshaller();

    public static RunbookMarshaller getInstance() {
        return instance;
    }

    public void marshall(Runbook runbook, ProtocolMarshaller protocolMarshaller) {
        if (runbook == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)runbook.getDocumentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)runbook.getDocumentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(runbook.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)runbook.getTargetParameterName(), TARGETPARAMETERNAME_BINDING);
            protocolMarshaller.marshall(runbook.getTargets(), TARGETS_BINDING);
            protocolMarshaller.marshall(runbook.getTargetMaps(), TARGETMAPS_BINDING);
            protocolMarshaller.marshall((Object)runbook.getMaxConcurrency(), MAXCONCURRENCY_BINDING);
            protocolMarshaller.marshall((Object)runbook.getMaxErrors(), MAXERRORS_BINDING);
            protocolMarshaller.marshall(runbook.getTargetLocations(), TARGETLOCATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

