/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostAddress {
    private static final int NO_PORT = -1;
    private final String host;
    private final int port;
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::(\\d*))?$");

    private HostAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHostText() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public int getPort() {
        if (!this.hasPort()) {
            throw new IllegalStateException("no port");
        }
        return this.port;
    }

    public int getPortOrDefault(int defaultPort) {
        return this.hasPort() ? this.port : defaultPort;
    }

    public static HostAddress fromParts(String host, int port) {
        if (!HostAddress.isValidPort(port)) {
            throw new IllegalArgumentException("Port is invalid: " + port);
        }
        HostAddress parsedHost = HostAddress.fromString(host);
        if (parsedHost.hasPort()) {
            throw new IllegalArgumentException("host contains a port declaration: " + host);
        }
        return new HostAddress(parsedHost.host, port);
    }

    @JsonCreator
    public static HostAddress fromString(String hostPortString) {
        String host;
        Objects.requireNonNull(hostPortString, "hostPortString is null");
        String portString = null;
        if (hostPortString.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(hostPortString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid bracketed host/port: " + hostPortString);
            }
            host = matcher.group(1);
            portString = matcher.group(2);
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
            }
        }
        int port = -1;
        if (portString != null && portString.length() != 0) {
            if (portString.startsWith("+")) {
                throw new IllegalArgumentException("Unparseable port number: " + hostPortString);
            }
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unparseable port number: " + hostPortString);
            }
            if (!HostAddress.isValidPort(port)) {
                throw new IllegalArgumentException("Port number out of range: " + hostPortString);
            }
        }
        return new HostAddress(host, port);
    }

    public static HostAddress fromUri(URI httpUri) {
        String host = httpUri.getHost();
        int port = httpUri.getPort();
        if (port < 0) {
            return HostAddress.fromString(host);
        }
        return HostAddress.fromParts(host, port);
    }

    public HostAddress withDefaultPort(int defaultPort) {
        if (!HostAddress.isValidPort(defaultPort)) {
            throw new IllegalArgumentException("Port number out of range: " + defaultPort);
        }
        if (this.hasPort() || this.port == defaultPort) {
            return this;
        }
        return new HostAddress(this.host, defaultPort);
    }

    public InetAddress toInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getHostText());
    }

    public List<InetAddress> getAllInetAddresses() throws UnknownHostException {
        return Collections.unmodifiableList(Arrays.asList(InetAddress.getAllByName(this.getHostText())));
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostAddress other = (HostAddress)obj;
        return Objects.equals(this.host, other.host) && Objects.equals(this.port, other.port);
    }

    @JsonValue
    public String toString() {
        StringBuilder builder = new StringBuilder(this.host.length() + 7);
        if (this.host.indexOf(58) >= 0) {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        if (this.hasPort()) {
            builder.append(':').append(this.port);
        }
        return builder.toString();
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }
}

