/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.EncoderUtil;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.LongArrayBlockBuilder;

public class LongArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "LONG_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (!block.mayHaveNull()) {
            sliceOutput.writeBytes(this.getValuesSlice(block));
        } else {
            long[] valuesWithoutNull = new long[positionCount];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = block.getLong(i, 0);
                if (block.isNull(i)) continue;
                ++nonNullPositionCount;
            }
            sliceOutput.writeInt(nonNullPositionCount);
            sliceOutput.writeBytes(Slices.wrappedLongArray((long[])valuesWithoutNull, (int)0, (int)nonNullPositionCount));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        long[] values = new long[positionCount];
        if (valueIsNull == null) {
            sliceInput.readBytes(Slices.wrappedLongArray((long[])values));
        } else {
            int nonNullPositionCount = sliceInput.readInt();
            sliceInput.readBytes(Slices.wrappedLongArray((long[])values, (int)0, (int)nonNullPositionCount));
            int position = nonNullPositionCount - 1;
            for (int i = positionCount - 1; i >= 0 && position >= 0; --i) {
                values[i] = values[position];
                if (valueIsNull[i]) continue;
                --position;
            }
        }
        return new LongArrayBlock(0, positionCount, valueIsNull, values);
    }

    private Slice getValuesSlice(Block block) {
        if (block instanceof LongArrayBlock) {
            return ((LongArrayBlock)block).getValuesSlice();
        }
        if (block instanceof LongArrayBlockBuilder) {
            return ((LongArrayBlockBuilder)block).getValuesSlice();
        }
        throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
    }
}

